\name{zTreeSbj}
\alias{zTreeSbj}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Read '.sbj' files generated by 'z-Tree' into R}
\description{
Read '.sbj' files which are written by the Microsoft Windows program
'z-Tree'. The latter is a software for developing and carrying out
economic experiments (see <http://www.ztree.uzh.ch/> for more information).}
\usage{
zTreeSbj(files, sep = "\\t", zTree.silent=getOption("zTree.silent"),
	zTree.encoding=getOption("zTree.encoding"))
}
\arguments{
  \item{files}{A vector of 'z-Tree' .sbj filenames}
  \item{sep}{'z-Tree' uses "\\t" as a separator. If you have a manipulated file, you
    might need to change the separator.}
  \item{zTree.silent}{If \code{TRUE}, generates less verbose output.}
  \item{zTree.encoding}{The default encoding is "LATIN1".}
}
\value{
A matrix with one entry for each subject.
}
\references{
  Urs Fischbacher. "z-Tree Manual 2.1 Experimenter's Manual." Zurich. 2002.
}
\author{Oliver Kirchkamp}

\seealso{See also \code{zTreeTables}}
\examples{
\dontrun{
files <- list.files(pattern = "*.sbj$",recursive=TRUE)
fname <- sub(".*/","",files)
sbj <- zTreeSbj(aggregate(files,list(fname),function(x) x[1])$x)
}}
\keyword{data}
\keyword{manip}
