% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lassie.R
\name{plot.lassie}
\alias{plot.lassie}
\title{Plot a lassie object}
\usage{
\method{plot}{lassie}(x, what_x = "local", digits = 3, low = "blue",
  mid = "white", high = "red", na = "purple", text_colour = "black",
  text_size, limits, midpoint, ...)
}
\arguments{
\item{x}{\code{\link[zebu]{lassie}} S3 object.}

\item{what_x}{vector specifying values to be returned:
\itemize{
\item 'local': local association measure values (default).
\item 'obs': observed probabilities.
\item 'exp': expected probabilities.
\item 'local_p': p-value of local association (after running \code{\link[zebu]{permtest}}).
}}

\item{digits}{integer indicating the number of decimal places.}

\item{low}{colour for low end of the gradient.}

\item{mid}{colour for midpoint of the gradient.}

\item{high}{colour for high end of the gradient.}

\item{na}{colour for NA values.}

\item{text_colour}{colour of text inside cells.}

\item{text_size}{integer indicating text size inside cells.}

\item{limits}{limits of gradient.}

\item{midpoint}{midpoint of gradient.}

\item{...}{other arguments passed on to methods. Not currently used.}
}
\description{
Plots a \code{\link[zebu]{lassie}} object as a tile plot using
the ggplot2 package. Only available for bivariate association.
}
\seealso{
\code{\link[zebu]{lassie}}
}

