% Generated by roxygen2 (4.1.0.9001): do not edit by hand
% Please edit documentation in R/functions_package.R
\name{Zeta.lm}
\alias{Zeta.lm}
\title{Linear regression of zeta for a set of environmental variables and distance}
\usage{
Zeta.lm(data.spec, data.env, xy = NULL, order = 1, sam = 1000,
  confint.level = 0.95, standard = TRUE, method = "mean",
  silent = FALSE)
}
\arguments{
\item{data.spec}{Site-by-species presence-absence data frame, with sites as rows and species as columns.}

\item{data.env}{Sites-by-variable data frame, with sites as rows and environmental variables as columns.}

\item{xy}{Site coordinates}

\item{order}{Specific number of assemblages or sites at which zeta diversity is computed.}

\item{sam}{Number of samples for which the zeta-diversity is computed.}

\item{confint.level}{Percentage for the confidence intervals of the coefficient from the linear regression.}

\item{standard}{Boolean parameter indicating if the spatial distances and differences in environmental variables should be standardized between 0 and 1.}

\item{method}{Indicates how to combine the pairwise differences and distances for more than 3 sites. Method can be "\code{mean}" or "\code{max}".}

\item{silent}{Boolean parameter indicating if warnings must be printed}
}
\value{
\code{Zeta.lm} returns a list containing the following components:

\item{model}{Object of class "\code{lm}", containing the output of the linear regression of zeta over the environmental variables.}

\item{confint}{The confidence intervals for the coefficients.}

\item{vif}{The variance inflation factors for all the variables.}
}
\description{
Computes the linear regression of zeta diversity for a given order (number of assemblages or sites) against a set of environmental variables and distances between sites.
}
\details{
The environmental variables can be numeric or factorial.
}
\examples{
data(BCI.spec.coarse)
xy <- BCI.spec.coarse[1:2]
data.spec <- BCI.spec.coarse[3:308]
data(BCI.env.coarse)
data.env <- BCI.env.coarse[10:15]

zeta.lm <- Zeta.lm(data.spec, data.env, sam = 100, order = 3)
zeta.lm
dev.new()
plot(zeta.lm$model)

zeta.lm <- Zeta.lm(data.spec, data.env, xy, sam = 100, order = 3)
zeta.lm
dev.new()
plot(zeta.lm$model)

##########

data(Marion.species)
xy <- Marion.species[1:2]
data.species <- Marion.species[3:33]
data(Marion.env)
data.env <- Marion.env[3:4]

zeta.lm.species <- Zeta.lm(data.species, data.env, sam = 100, order = 3)
zeta.lm.species
dev.new()
plot(zeta.lm.species$model)

zeta.lm.species <- Zeta.lm(data.species, data.env, xy, sam = 100, order = 2)
zeta.lm.species
dev.new()
plot(zeta.lm.species$model)
}
\references{
Hui C. & McGeoch M.A. (2014). Zeta diversity as a concept and metric that unifies incidence-based biodiversity patterns. \emph{The American Naturalist}, 184, 684-694.
}
\seealso{
\code{\link{Zeta.decline}}, \code{\link{Zeta.order}}, \code{\link{Zeta.gam}}
}

