% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zipfPolylogFit.R
\name{zipfPolylogFit}
\alias{zipfPolylogFit}
\alias{residuals.zipfPolyR}
\alias{fitted.zipfPolyR}
\alias{coef.zipfPolyR}
\alias{plot.zipfPolyR}
\alias{print.zipfPolyR}
\alias{summary.zipfPolyR}
\alias{logLik.zipfPolyR}
\alias{AIC.zipfPolyR}
\alias{BIC.zipfPolyR}
\title{ZipfPolylog parameters estimation.}
\usage{
zipfPolylogFit(data, init_alpha, init_beta, level = 0.95, ...)

\method{residuals}{zipfPolyR}(object, ...)

\method{fitted}{zipfPolyR}(object, ...)

\method{coef}{zipfPolyR}(object, ...)

\method{plot}{zipfPolyR}(x, ...)

\method{print}{zipfPolyR}(x, ...)

\method{summary}{zipfPolyR}(object, ...)

\method{logLik}{zipfPolyR}(object, ...)

\method{AIC}{zipfPolyR}(object, ...)

\method{BIC}{zipfPolyR}(object, ...)
}
\arguments{
\item{data}{Matrix of count data in form of a table of frequencies.}

\item{init_alpha}{Initial value of \eqn{\alpha} parameter (\eqn{\alpha > 1}).}

\item{init_beta}{Initial value of \eqn{\beta} parameter (\eqn{\beta > 0}).}

\item{level}{Confidence level used to calculate the confidence intervals (default 0.95).}

\item{...}{Further arguments to the generic functions. The extra arguments are passing to the \emph{\link{optim}} function.}

\item{object}{An object from class "zipfPolyR" (output of \emph{zipfPolylogFit} function).}

\item{x}{An object from class "zipfPolyR" (output of \emph{zipfPolylogFit} function).}
}
\value{
Returns a \emph{zipfPolyR} object composed by the maximum likelihood parameter estimations
jointly with their standard deviation and confidence intervals. It also contains
the value of the log-likelihood at the maximum likelihood estimator.
}
\description{
For a given sample of strictly positive integer numbers,  usually of the type of ranking data or
frequencies of frequencies data, estimates the parameters of the ZipfPolylog distribution by means of
the maximum likelihood method. The input data should be provided as a frequency matrix.
}
\details{
The argument \code{data} is a two column matrix with the first column containing the observations and
the second column containing their frequencies.

The log-likelihood function is equal to:

The function \emph{\link{optim}} is used to estimate the parameters.
}
