% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/zresults-methods.R,
%   R/zvariant-methods.R
\docType{methods}
\name{cost}
\alias{cost}
\alias{cost,Zresults-method}
\alias{cost,Zvariant-method}
\alias{cost,Zresults-method}
\title{Get cost data of a Z* object.}
\usage{
cost(x)

\S4method{cost}{Zresults}(x)

\S4method{cost}{Zvariant}(x)
}
\arguments{
\item{x}{Z* object.}
}
\value{
data.frame object with two columns:
\itemize{
  \item{\code{pr_lost}}{Proportion of landscape lost.}
  \item{\code{cost}}{Cost of a given fraction of the solution.}
}
If no results are available, return NA.
}
\description{
Returns the "cost_needed_for_top_fraction" column from Zonation curves
file. Note that the cost is the same in curves and grp_curves files.
pr_lost is always included in the returned data, but no other columns are
included.
}
\details{
Method implementation in class \code{\link{Zvariant}} is just a thin
wrapper for passing the argumets to variant's code{\link{Zresults}} object.
}
\seealso{
\code{\link{Zresults-class}} \code{\link{Zvariant-class}}
}
\author{
Joona Lehtomaki \email{joona.lehtomaki@gmail.com}
}
\keyword{results}
