% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/zresults-methods.R,
%   R/zvariant-methods.R
\name{features_info}
\alias{features_info}
\alias{features_info,Zresults-method}
\alias{features_info,Zvariant-method}
\title{Get the features info component of Zresults.}
\usage{
features_info(x)

\S4method{features_info}{Zresults}(x)

\S4method{features_info}{Zvariant}(x)
}
\arguments{
\item{x}{Z* object.}
}
\value{
data.frame containing the features info data.
}
\description{
Returns the data in *.features_info.txt results standard output of
Zonation if present.
}
\details{
Argument \code{x} can be an instance of one the following Z* classes:
\itemize{
  \item{\code{Zvariant}}
  \item{\code{Zresults}}
}
}
\examples{
\dontrun{
 setup.dir <- system.file("extdata/tutorial/basic", package="zonator")
 tutorial.project <- create_zproject(setup.dir)
 variant.caz <- get_variant(tutorial.project, "01")

 # Feature names for a Zvariant object
 features_info(variant_caz)
}

}
\seealso{
\code{\link{Zvariant-class}} \code{\link{Zresults-class}}
         \code{\link{groupnames}} \code{\link{groups}}
}
\author{
Joona Lehtomaki \email{joona.lehtomaki@gmail.com}
}
