rollapply <- function(data, width, FUN, ..., by = 1, ascending = TRUE,
  by.column = TRUE, na.pad = FALSE, align = c("center", "left", "right"))
    UseMethod("rollapply")

## up to zoo 1.2-0 rollapply was called rapply(), it was deprecated
## up to zoo 1.3-x and removed in zoo 1.4-0.
## 
## rapply <- function(data, width, FUN, ..., by = 1, ascending = TRUE,
##   by.column = TRUE, na.pad = FALSE, align = c("center", "left", "right"))
## {
##     .Deprecated("rollapply")
##     UseMethod("rollapply")
## }

rollapply.zoo <- function(data, width, FUN, ..., by = 1, ascending = TRUE, by.column = TRUE, na.pad = FALSE,
  align = c("center", "left", "right")) {
    itt <- 0
    embedi <- function(n, k, by = 1, ascending = FALSE) {
    # n = no of time points, k = number of columns
    # by = increment. normally =1 but if =b calc every b-th point 
    # ascending If TRUE, points passed in ascending order else descending.
    # Note that embed(1:n,k) corresponds to embedi(n,k,by=1,rev=TRUE)
    # e.g. embedi(10,3)
    	    s <- seq(1,n-k+1,by)
    	    lens <- length(s)
    	    cols <- if (ascending) 1:k else k:1
    	    matrix(s + rep(cols,rep(lens,k))-1,lens)
    }

    if (by.column && by == 1 && ascending && is.null(list(...))) 
	switch(deparse(substitute(FUN)),
		mean = return(rollmean(data, width, na.pad = na.pad, align = align)),
		max = return(rollmax(data, width, na.pad = na.pad, align = align)),
		median = return(rollmedian(data, width, na.pad = na.pad, align = align)))

    ## evaluate FUN only on coredata(data)
    cdata <- coredata(data)
    nr <- NROW(cdata)
    width <- as.integer(width)[1]
    stopifnot( width > 0, width <= nr )
    
    ## process alignment
    align <- match.arg(align)
    n1 <- switch(align,    
      "left" = { width - 1},
      "center" = { floor(width/2) },
      "right" = { 0 })    
    tt <- index(data)[seq((width-n1), (nr-n1), by)]

    FUN <- match.fun(FUN)
    e <- embedi(nr, width, by, ascending)
    res <- if (is.null(dim(cdata))) {
           xx <- sapply(1:nrow(e), function(i) FUN(cdata[e[i,]], ...))
	   if (! is.null(dim(xx))) xx <- t(xx)
	   zoo(xx, tt, if (by == 1) attr(data, "frequency"))
    } else if (by.column) {
	    # e <- embedi(nr, width, by, ascending)
	    zoo( sapply( 1:ncol(cdata), function(i)
			apply( e, 1, function(st) FUN(cdata[st,i], ...) ) ),
			tt, if (by == 1) attr(data, "frequency")
	    )
    } else {
           rval <- apply(embedi(nr, width, by, ascending), 1, function(st) FUN(cdata[st,], ...))
	   if(!is.null(dim(rval))) rval <- t(rval)
	   zoo(rval, tt, if (by == 1) attr(data, "frequency"))
    }	   
    res <- if (na.pad) merge(res, zoo(,index(data), attr(data, "frequency"))) else res
    if(by.column && !is.null(dim(cdata))) colnames(res) <- colnames(cdata)
    return(res)
} 

rollapply.ts <- function(data, width, FUN, by = 1, ascending = TRUE, by.column = TRUE, na.pad = FALSE, ...)
  as.ts(rollapply(as.zoo(data), width = width, FUN = FUN, by = by, ascending = ascending,
               by.column = by.column, na.pad = na.pad, ...))
