% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cast2zoocat.R
\name{cast2zoocat}
\alias{cast2zoocat}
\title{Cast a data frame to a \code{zoocat} object}
\usage{
cast2zoocat(x, index.var, value.var, attr.var = NULL, fun.aggregate = NULL,
  del.unique.cattr = TRUE)
}
\arguments{
\item{x}{a data frame.}

\item{index.var}{the name of the column to be treated as the index of the
\code{zoocat} object.}

\item{value.var}{the name of the column which stored the values.}

\item{attr.var}{the name of the column which will be used as column attributes of 
the \code{zoocat} object. If NULL, all columns except \code{value.var} and \code{index.var}
will be used.}

\item{fun.aggregate}{aggregation function needed if variables do not identify a single observation
for each output cell. Defaults to length (with a message) if needed but not specified.
See \code{\link{dcast}}.}

\item{del.unique.cattr}{logical. If TRUE, the column attibutes with unique value will
be deleted.}
}
\value{
a "\code{zoocat}" object.
}
\description{
Cast a data frame to a "\code{zoocat}" object. The data frame should be 
a long format data frame (for example, melted by \code{reshape2::melt}).
}
\examples{

df <- data.frame(year = rep(1991 : 1995, each = 24), month = rep(1 : 12, 10),
                 varname = rep(c('a', 'b'), each = 12), city = rep(1 : 3, each = 40),
                 value = 1 : 120)
cast2zoocat(df, index.var = 'year', value.var = 'value')
cast2zoocat(df, index.var = 'year', value.var = 'value', attr.var = 'varname')

## This is the air quality example from package reshape2
names(airquality) <- tolower(names(airquality))
aqm <- melt(airquality, id = c("month", "day"), na.rm=TRUE) 
head(aqm)
cast2zoocat(aqm, index.var = 'month', value.var = 'value', attr.var = 'variable')
cast2zoocat(aqm, index.var = 'month', value.var = 'value')


}

