% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RemoveNACases.R
\name{RemoveNACases}
\alias{RemoveNACases}
\title{Remove Cases Missing All Measurements}
\usage{
RemoveNACases(data, measureNames = NULL, prefix = logPrefix)
}
\arguments{
\item{data}{A dataframe with the input measurements.}

\item{measureNames}{A vector of characters with the list of measurements
to be considered for missing values. If \code{NULL} (default), all measurements
starting by \code{prefix} are considered.}

\item{prefix}{A character string with the initial pattern to select the
list of measurements. The default is given by the internal variable
\code{logPrefix}. It is in effect only when \code{measureNames = NULL}.}
}
\value{
A dataframe with the same columns as the input dataframe but
removing the rows with missing values for all measurements in the list.
}
\description{
Function to remove the table rows for which all measurements of interest
are non-available (NA).
A particular list of measurement names can be explicitly provided
or selected by a common initial pattern.
The default setting removes the rows with no log-ratio available.
}
\examples{
## Read an example dataset:
dataFile <- system.file("extdata", "dataValenzuelaLamas2008.csv.gz",
                        package = "zoolog")
dataExample <- utils::read.csv2(dataFile,
                                na.strings = "",
                                encoding = "UTF-8",
                                stringsAsFactors = TRUE)
## We can observe the first lines (excluding some columns for visibility):
head(dataExample)[, -c(6:20,32:64)]

## Remove the cases not including any measurement present in the reference.
refMeasureNames <- levels(factor(reference$Combi$Measure))
refMeasureNames
dataExamplePruned <- RemoveNACases(dataExample,
                                   measureNames = refMeasureNames)
## The first lines of the output data frame show at least one available
## measurement value in the selected list:
head(dataExamplePruned)[, -c(6:20,32:64)]

## If we compute first the log-ratios
dataExampleWithLogs <- LogRatios(dataExample)
## the cases not including any log-ratio can be removed with the
## default logPrefix
dataExampleWithLogsPruned <- RemoveNACases(dataExampleWithLogs)
head(dataExampleWithLogsPruned)[, -c(6:20,32:64)]
}
