


#![allow(unused_variables)]
#![allow(clippy::needless_pass_by_ref_mut)]
#[cfg(any(feature = "full", feature = "derive"))]
use crate::punctuated::Punctuated;
use crate::*;
use proc_macro2::Span;
#[cfg(feature = "full")]
macro_rules! full {
    ($e:expr) => {
        $e
    };
}
#[cfg(all(feature = "derive", not(feature = "full")))]
macro_rules! full {
    ($e:expr) => {
        unreachable!()
    };
}
macro_rules! skip {
    ($($tt:tt)*) => {};
}





pub trait Visit<'ast> {
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_abi(&mut self, i: &'ast Abi) {
        visit_abi(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_angle_bracketed_generic_arguments(
        &mut self,
        i: &'ast AngleBracketedGenericArguments,
    ) {
        visit_angle_bracketed_generic_arguments(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_arm(&mut self, i: &'ast Arm) {
        visit_arm(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_assoc_const(&mut self, i: &'ast AssocConst) {
        visit_assoc_const(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_assoc_type(&mut self, i: &'ast AssocType) {
        visit_assoc_type(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_attr_style(&mut self, i: &'ast AttrStyle) {
        visit_attr_style(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_attribute(&mut self, i: &'ast Attribute) {
        visit_attribute(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_bare_fn_arg(&mut self, i: &'ast BareFnArg) {
        visit_bare_fn_arg(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_bare_variadic(&mut self, i: &'ast BareVariadic) {
        visit_bare_variadic(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_bin_op(&mut self, i: &'ast BinOp) {
        visit_bin_op(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_block(&mut self, i: &'ast Block) {
        visit_block(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_bound_lifetimes(&mut self, i: &'ast BoundLifetimes) {
        visit_bound_lifetimes(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_const_param(&mut self, i: &'ast ConstParam) {
        visit_const_param(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_constraint(&mut self, i: &'ast Constraint) {
        visit_constraint(self, i);
    }
    #[cfg(feature = "derive")]
    fn visit_data(&mut self, i: &'ast Data) {
        visit_data(self, i);
    }
    #[cfg(feature = "derive")]
    fn visit_data_enum(&mut self, i: &'ast DataEnum) {
        visit_data_enum(self, i);
    }
    #[cfg(feature = "derive")]
    fn visit_data_struct(&mut self, i: &'ast DataStruct) {
        visit_data_struct(self, i);
    }
    #[cfg(feature = "derive")]
    fn visit_data_union(&mut self, i: &'ast DataUnion) {
        visit_data_union(self, i);
    }
    #[cfg(feature = "derive")]
    fn visit_derive_input(&mut self, i: &'ast DeriveInput) {
        visit_derive_input(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_expr(&mut self, i: &'ast Expr) {
        visit_expr(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_expr_array(&mut self, i: &'ast ExprArray) {
        visit_expr_array(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_expr_assign(&mut self, i: &'ast ExprAssign) {
        visit_expr_assign(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_expr_async(&mut self, i: &'ast ExprAsync) {
        visit_expr_async(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_expr_await(&mut self, i: &'ast ExprAwait) {
        visit_expr_await(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_expr_binary(&mut self, i: &'ast ExprBinary) {
        visit_expr_binary(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_expr_block(&mut self, i: &'ast ExprBlock) {
        visit_expr_block(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_expr_break(&mut self, i: &'ast ExprBreak) {
        visit_expr_break(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_expr_call(&mut self, i: &'ast ExprCall) {
        visit_expr_call(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_expr_cast(&mut self, i: &'ast ExprCast) {
        visit_expr_cast(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_expr_closure(&mut self, i: &'ast ExprClosure) {
        visit_expr_closure(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_expr_const(&mut self, i: &'ast ExprConst) {
        visit_expr_const(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_expr_continue(&mut self, i: &'ast ExprContinue) {
        visit_expr_continue(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_expr_field(&mut self, i: &'ast ExprField) {
        visit_expr_field(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_expr_for_loop(&mut self, i: &'ast ExprForLoop) {
        visit_expr_for_loop(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_expr_group(&mut self, i: &'ast ExprGroup) {
        visit_expr_group(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_expr_if(&mut self, i: &'ast ExprIf) {
        visit_expr_if(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_expr_index(&mut self, i: &'ast ExprIndex) {
        visit_expr_index(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_expr_infer(&mut self, i: &'ast ExprInfer) {
        visit_expr_infer(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_expr_let(&mut self, i: &'ast ExprLet) {
        visit_expr_let(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_expr_lit(&mut self, i: &'ast ExprLit) {
        visit_expr_lit(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_expr_loop(&mut self, i: &'ast ExprLoop) {
        visit_expr_loop(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_expr_macro(&mut self, i: &'ast ExprMacro) {
        visit_expr_macro(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_expr_match(&mut self, i: &'ast ExprMatch) {
        visit_expr_match(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_expr_method_call(&mut self, i: &'ast ExprMethodCall) {
        visit_expr_method_call(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_expr_paren(&mut self, i: &'ast ExprParen) {
        visit_expr_paren(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_expr_path(&mut self, i: &'ast ExprPath) {
        visit_expr_path(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_expr_range(&mut self, i: &'ast ExprRange) {
        visit_expr_range(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_expr_reference(&mut self, i: &'ast ExprReference) {
        visit_expr_reference(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_expr_repeat(&mut self, i: &'ast ExprRepeat) {
        visit_expr_repeat(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_expr_return(&mut self, i: &'ast ExprReturn) {
        visit_expr_return(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_expr_struct(&mut self, i: &'ast ExprStruct) {
        visit_expr_struct(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_expr_try(&mut self, i: &'ast ExprTry) {
        visit_expr_try(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_expr_try_block(&mut self, i: &'ast ExprTryBlock) {
        visit_expr_try_block(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_expr_tuple(&mut self, i: &'ast ExprTuple) {
        visit_expr_tuple(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_expr_unary(&mut self, i: &'ast ExprUnary) {
        visit_expr_unary(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_expr_unsafe(&mut self, i: &'ast ExprUnsafe) {
        visit_expr_unsafe(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_expr_while(&mut self, i: &'ast ExprWhile) {
        visit_expr_while(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_expr_yield(&mut self, i: &'ast ExprYield) {
        visit_expr_yield(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_field(&mut self, i: &'ast Field) {
        visit_field(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_field_mutability(&mut self, i: &'ast FieldMutability) {
        visit_field_mutability(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_field_pat(&mut self, i: &'ast FieldPat) {
        visit_field_pat(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_field_value(&mut self, i: &'ast FieldValue) {
        visit_field_value(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_fields(&mut self, i: &'ast Fields) {
        visit_fields(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_fields_named(&mut self, i: &'ast FieldsNamed) {
        visit_fields_named(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_fields_unnamed(&mut self, i: &'ast FieldsUnnamed) {
        visit_fields_unnamed(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_file(&mut self, i: &'ast File) {
        visit_file(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_fn_arg(&mut self, i: &'ast FnArg) {
        visit_fn_arg(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_foreign_item(&mut self, i: &'ast ForeignItem) {
        visit_foreign_item(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_foreign_item_fn(&mut self, i: &'ast ForeignItemFn) {
        visit_foreign_item_fn(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_foreign_item_macro(&mut self, i: &'ast ForeignItemMacro) {
        visit_foreign_item_macro(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_foreign_item_static(&mut self, i: &'ast ForeignItemStatic) {
        visit_foreign_item_static(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_foreign_item_type(&mut self, i: &'ast ForeignItemType) {
        visit_foreign_item_type(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_generic_argument(&mut self, i: &'ast GenericArgument) {
        visit_generic_argument(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_generic_param(&mut self, i: &'ast GenericParam) {
        visit_generic_param(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_generics(&mut self, i: &'ast Generics) {
        visit_generics(self, i);
    }
    fn visit_ident(&mut self, i: &'ast Ident) {
        visit_ident(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_impl_item(&mut self, i: &'ast ImplItem) {
        visit_impl_item(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_impl_item_const(&mut self, i: &'ast ImplItemConst) {
        visit_impl_item_const(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_impl_item_fn(&mut self, i: &'ast ImplItemFn) {
        visit_impl_item_fn(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_impl_item_macro(&mut self, i: &'ast ImplItemMacro) {
        visit_impl_item_macro(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_impl_item_type(&mut self, i: &'ast ImplItemType) {
        visit_impl_item_type(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_impl_restriction(&mut self, i: &'ast ImplRestriction) {
        visit_impl_restriction(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_index(&mut self, i: &'ast Index) {
        visit_index(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_item(&mut self, i: &'ast Item) {
        visit_item(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_item_const(&mut self, i: &'ast ItemConst) {
        visit_item_const(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_item_enum(&mut self, i: &'ast ItemEnum) {
        visit_item_enum(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_item_extern_crate(&mut self, i: &'ast ItemExternCrate) {
        visit_item_extern_crate(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_item_fn(&mut self, i: &'ast ItemFn) {
        visit_item_fn(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_item_foreign_mod(&mut self, i: &'ast ItemForeignMod) {
        visit_item_foreign_mod(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_item_impl(&mut self, i: &'ast ItemImpl) {
        visit_item_impl(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_item_macro(&mut self, i: &'ast ItemMacro) {
        visit_item_macro(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_item_mod(&mut self, i: &'ast ItemMod) {
        visit_item_mod(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_item_static(&mut self, i: &'ast ItemStatic) {
        visit_item_static(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_item_struct(&mut self, i: &'ast ItemStruct) {
        visit_item_struct(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_item_trait(&mut self, i: &'ast ItemTrait) {
        visit_item_trait(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_item_trait_alias(&mut self, i: &'ast ItemTraitAlias) {
        visit_item_trait_alias(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_item_type(&mut self, i: &'ast ItemType) {
        visit_item_type(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_item_union(&mut self, i: &'ast ItemUnion) {
        visit_item_union(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_item_use(&mut self, i: &'ast ItemUse) {
        visit_item_use(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_label(&mut self, i: &'ast Label) {
        visit_label(self, i);
    }
    fn visit_lifetime(&mut self, i: &'ast Lifetime) {
        visit_lifetime(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_lifetime_param(&mut self, i: &'ast LifetimeParam) {
        visit_lifetime_param(self, i);
    }
    fn visit_lit(&mut self, i: &'ast Lit) {
        visit_lit(self, i);
    }
    fn visit_lit_bool(&mut self, i: &'ast LitBool) {
        visit_lit_bool(self, i);
    }
    fn visit_lit_byte(&mut self, i: &'ast LitByte) {
        visit_lit_byte(self, i);
    }
    fn visit_lit_byte_str(&mut self, i: &'ast LitByteStr) {
        visit_lit_byte_str(self, i);
    }
    fn visit_lit_char(&mut self, i: &'ast LitChar) {
        visit_lit_char(self, i);
    }
    fn visit_lit_float(&mut self, i: &'ast LitFloat) {
        visit_lit_float(self, i);
    }
    fn visit_lit_int(&mut self, i: &'ast LitInt) {
        visit_lit_int(self, i);
    }
    fn visit_lit_str(&mut self, i: &'ast LitStr) {
        visit_lit_str(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_local(&mut self, i: &'ast Local) {
        visit_local(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_local_init(&mut self, i: &'ast LocalInit) {
        visit_local_init(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_macro(&mut self, i: &'ast Macro) {
        visit_macro(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_macro_delimiter(&mut self, i: &'ast MacroDelimiter) {
        visit_macro_delimiter(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_member(&mut self, i: &'ast Member) {
        visit_member(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_meta(&mut self, i: &'ast Meta) {
        visit_meta(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_meta_list(&mut self, i: &'ast MetaList) {
        visit_meta_list(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_meta_name_value(&mut self, i: &'ast MetaNameValue) {
        visit_meta_name_value(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_parenthesized_generic_arguments(
        &mut self,
        i: &'ast ParenthesizedGenericArguments,
    ) {
        visit_parenthesized_generic_arguments(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_pat(&mut self, i: &'ast Pat) {
        visit_pat(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_pat_ident(&mut self, i: &'ast PatIdent) {
        visit_pat_ident(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_pat_or(&mut self, i: &'ast PatOr) {
        visit_pat_or(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_pat_paren(&mut self, i: &'ast PatParen) {
        visit_pat_paren(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_pat_reference(&mut self, i: &'ast PatReference) {
        visit_pat_reference(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_pat_rest(&mut self, i: &'ast PatRest) {
        visit_pat_rest(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_pat_slice(&mut self, i: &'ast PatSlice) {
        visit_pat_slice(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_pat_struct(&mut self, i: &'ast PatStruct) {
        visit_pat_struct(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_pat_tuple(&mut self, i: &'ast PatTuple) {
        visit_pat_tuple(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_pat_tuple_struct(&mut self, i: &'ast PatTupleStruct) {
        visit_pat_tuple_struct(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_pat_type(&mut self, i: &'ast PatType) {
        visit_pat_type(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_pat_wild(&mut self, i: &'ast PatWild) {
        visit_pat_wild(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_path(&mut self, i: &'ast Path) {
        visit_path(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_path_arguments(&mut self, i: &'ast PathArguments) {
        visit_path_arguments(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_path_segment(&mut self, i: &'ast PathSegment) {
        visit_path_segment(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_predicate_lifetime(&mut self, i: &'ast PredicateLifetime) {
        visit_predicate_lifetime(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_predicate_type(&mut self, i: &'ast PredicateType) {
        visit_predicate_type(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_qself(&mut self, i: &'ast QSelf) {
        visit_qself(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_range_limits(&mut self, i: &'ast RangeLimits) {
        visit_range_limits(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_receiver(&mut self, i: &'ast Receiver) {
        visit_receiver(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_return_type(&mut self, i: &'ast ReturnType) {
        visit_return_type(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_signature(&mut self, i: &'ast Signature) {
        visit_signature(self, i);
    }
    fn visit_span(&mut self, i: &Span) {
        visit_span(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_static_mutability(&mut self, i: &'ast StaticMutability) {
        visit_static_mutability(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_stmt(&mut self, i: &'ast Stmt) {
        visit_stmt(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_stmt_macro(&mut self, i: &'ast StmtMacro) {
        visit_stmt_macro(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_trait_bound(&mut self, i: &'ast TraitBound) {
        visit_trait_bound(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_trait_bound_modifier(&mut self, i: &'ast TraitBoundModifier) {
        visit_trait_bound_modifier(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_trait_item(&mut self, i: &'ast TraitItem) {
        visit_trait_item(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_trait_item_const(&mut self, i: &'ast TraitItemConst) {
        visit_trait_item_const(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_trait_item_fn(&mut self, i: &'ast TraitItemFn) {
        visit_trait_item_fn(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_trait_item_macro(&mut self, i: &'ast TraitItemMacro) {
        visit_trait_item_macro(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_trait_item_type(&mut self, i: &'ast TraitItemType) {
        visit_trait_item_type(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_type(&mut self, i: &'ast Type) {
        visit_type(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_type_array(&mut self, i: &'ast TypeArray) {
        visit_type_array(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_type_bare_fn(&mut self, i: &'ast TypeBareFn) {
        visit_type_bare_fn(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_type_group(&mut self, i: &'ast TypeGroup) {
        visit_type_group(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_type_impl_trait(&mut self, i: &'ast TypeImplTrait) {
        visit_type_impl_trait(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_type_infer(&mut self, i: &'ast TypeInfer) {
        visit_type_infer(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_type_macro(&mut self, i: &'ast TypeMacro) {
        visit_type_macro(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_type_never(&mut self, i: &'ast TypeNever) {
        visit_type_never(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_type_param(&mut self, i: &'ast TypeParam) {
        visit_type_param(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_type_param_bound(&mut self, i: &'ast TypeParamBound) {
        visit_type_param_bound(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_type_paren(&mut self, i: &'ast TypeParen) {
        visit_type_paren(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_type_path(&mut self, i: &'ast TypePath) {
        visit_type_path(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_type_ptr(&mut self, i: &'ast TypePtr) {
        visit_type_ptr(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_type_reference(&mut self, i: &'ast TypeReference) {
        visit_type_reference(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_type_slice(&mut self, i: &'ast TypeSlice) {
        visit_type_slice(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_type_trait_object(&mut self, i: &'ast TypeTraitObject) {
        visit_type_trait_object(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_type_tuple(&mut self, i: &'ast TypeTuple) {
        visit_type_tuple(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_un_op(&mut self, i: &'ast UnOp) {
        visit_un_op(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_use_glob(&mut self, i: &'ast UseGlob) {
        visit_use_glob(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_use_group(&mut self, i: &'ast UseGroup) {
        visit_use_group(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_use_name(&mut self, i: &'ast UseName) {
        visit_use_name(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_use_path(&mut self, i: &'ast UsePath) {
        visit_use_path(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_use_rename(&mut self, i: &'ast UseRename) {
        visit_use_rename(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_use_tree(&mut self, i: &'ast UseTree) {
        visit_use_tree(self, i);
    }
    #[cfg(feature = "full")]
    fn visit_variadic(&mut self, i: &'ast Variadic) {
        visit_variadic(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_variant(&mut self, i: &'ast Variant) {
        visit_variant(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_vis_restricted(&mut self, i: &'ast VisRestricted) {
        visit_vis_restricted(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_visibility(&mut self, i: &'ast Visibility) {
        visit_visibility(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_where_clause(&mut self, i: &'ast WhereClause) {
        visit_where_clause(self, i);
    }
    #[cfg(any(feature = "derive", feature = "full"))]
    fn visit_where_predicate(&mut self, i: &'ast WherePredicate) {
        visit_where_predicate(self, i);
    }
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_abi<'ast, V>(v: &mut V, node: &'ast Abi)
where
    V: Visit<'ast> + ?Sized,
{
    skip!(node.extern_token);
    if let Some(it) = &node.name {
        v.visit_lit_str(it);
    }
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_angle_bracketed_generic_arguments<'ast, V>(
    v: &mut V,
    node: &'ast AngleBracketedGenericArguments,
)
where
    V: Visit<'ast> + ?Sized,
{
    skip!(node.colon2_token);
    skip!(node.lt_token);
    for el in Punctuated::pairs(&node.args) {
        let it = el.value();
        v.visit_generic_argument(it);
    }
    skip!(node.gt_token);
}
#[cfg(feature = "full")]
pub fn visit_arm<'ast, V>(v: &mut V, node: &'ast Arm)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    v.visit_pat(&node.pat);
    if let Some(it) = &node.guard {
        skip!((it).0);
        v.visit_expr(&*(it).1);
    }
    skip!(node.fat_arrow_token);
    v.visit_expr(&*node.body);
    skip!(node.comma);
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_assoc_const<'ast, V>(v: &mut V, node: &'ast AssocConst)
where
    V: Visit<'ast> + ?Sized,
{
    v.visit_ident(&node.ident);
    if let Some(it) = &node.generics {
        v.visit_angle_bracketed_generic_arguments(it);
    }
    skip!(node.eq_token);
    v.visit_expr(&node.value);
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_assoc_type<'ast, V>(v: &mut V, node: &'ast AssocType)
where
    V: Visit<'ast> + ?Sized,
{
    v.visit_ident(&node.ident);
    if let Some(it) = &node.generics {
        v.visit_angle_bracketed_generic_arguments(it);
    }
    skip!(node.eq_token);
    v.visit_type(&node.ty);
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_attr_style<'ast, V>(v: &mut V, node: &'ast AttrStyle)
where
    V: Visit<'ast> + ?Sized,
{
    match node {
        AttrStyle::Outer => {}
        AttrStyle::Inner(_binding_0) => {
            skip!(_binding_0);
        }
    }
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_attribute<'ast, V>(v: &mut V, node: &'ast Attribute)
where
    V: Visit<'ast> + ?Sized,
{
    skip!(node.pound_token);
    v.visit_attr_style(&node.style);
    skip!(node.bracket_token);
    v.visit_meta(&node.meta);
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_bare_fn_arg<'ast, V>(v: &mut V, node: &'ast BareFnArg)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    if let Some(it) = &node.name {
        v.visit_ident(&(it).0);
        skip!((it).1);
    }
    v.visit_type(&node.ty);
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_bare_variadic<'ast, V>(v: &mut V, node: &'ast BareVariadic)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    if let Some(it) = &node.name {
        v.visit_ident(&(it).0);
        skip!((it).1);
    }
    skip!(node.dots);
    skip!(node.comma);
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_bin_op<'ast, V>(v: &mut V, node: &'ast BinOp)
where
    V: Visit<'ast> + ?Sized,
{
    match node {
        BinOp::Add(_binding_0) => {
            skip!(_binding_0);
        }
        BinOp::Sub(_binding_0) => {
            skip!(_binding_0);
        }
        BinOp::Mul(_binding_0) => {
            skip!(_binding_0);
        }
        BinOp::Div(_binding_0) => {
            skip!(_binding_0);
        }
        BinOp::Rem(_binding_0) => {
            skip!(_binding_0);
        }
        BinOp::And(_binding_0) => {
            skip!(_binding_0);
        }
        BinOp::Or(_binding_0) => {
            skip!(_binding_0);
        }
        BinOp::BitXor(_binding_0) => {
            skip!(_binding_0);
        }
        BinOp::BitAnd(_binding_0) => {
            skip!(_binding_0);
        }
        BinOp::BitOr(_binding_0) => {
            skip!(_binding_0);
        }
        BinOp::Shl(_binding_0) => {
            skip!(_binding_0);
        }
        BinOp::Shr(_binding_0) => {
            skip!(_binding_0);
        }
        BinOp::Eq(_binding_0) => {
            skip!(_binding_0);
        }
        BinOp::Lt(_binding_0) => {
            skip!(_binding_0);
        }
        BinOp::Le(_binding_0) => {
            skip!(_binding_0);
        }
        BinOp::Ne(_binding_0) => {
            skip!(_binding_0);
        }
        BinOp::Ge(_binding_0) => {
            skip!(_binding_0);
        }
        BinOp::Gt(_binding_0) => {
            skip!(_binding_0);
        }
        BinOp::AddAssign(_binding_0) => {
            skip!(_binding_0);
        }
        BinOp::SubAssign(_binding_0) => {
            skip!(_binding_0);
        }
        BinOp::MulAssign(_binding_0) => {
            skip!(_binding_0);
        }
        BinOp::DivAssign(_binding_0) => {
            skip!(_binding_0);
        }
        BinOp::RemAssign(_binding_0) => {
            skip!(_binding_0);
        }
        BinOp::BitXorAssign(_binding_0) => {
            skip!(_binding_0);
        }
        BinOp::BitAndAssign(_binding_0) => {
            skip!(_binding_0);
        }
        BinOp::BitOrAssign(_binding_0) => {
            skip!(_binding_0);
        }
        BinOp::ShlAssign(_binding_0) => {
            skip!(_binding_0);
        }
        BinOp::ShrAssign(_binding_0) => {
            skip!(_binding_0);
        }
    }
}
#[cfg(feature = "full")]
pub fn visit_block<'ast, V>(v: &mut V, node: &'ast Block)
where
    V: Visit<'ast> + ?Sized,
{
    skip!(node.brace_token);
    for it in &node.stmts {
        v.visit_stmt(it);
    }
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_bound_lifetimes<'ast, V>(v: &mut V, node: &'ast BoundLifetimes)
where
    V: Visit<'ast> + ?Sized,
{
    skip!(node.for_token);
    skip!(node.lt_token);
    for el in Punctuated::pairs(&node.lifetimes) {
        let it = el.value();
        v.visit_generic_param(it);
    }
    skip!(node.gt_token);
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_const_param<'ast, V>(v: &mut V, node: &'ast ConstParam)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    skip!(node.const_token);
    v.visit_ident(&node.ident);
    skip!(node.colon_token);
    v.visit_type(&node.ty);
    skip!(node.eq_token);
    if let Some(it) = &node.default {
        v.visit_expr(it);
    }
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_constraint<'ast, V>(v: &mut V, node: &'ast Constraint)
where
    V: Visit<'ast> + ?Sized,
{
    v.visit_ident(&node.ident);
    if let Some(it) = &node.generics {
        v.visit_angle_bracketed_generic_arguments(it);
    }
    skip!(node.colon_token);
    for el in Punctuated::pairs(&node.bounds) {
        let it = el.value();
        v.visit_type_param_bound(it);
    }
}
#[cfg(feature = "derive")]
pub fn visit_data<'ast, V>(v: &mut V, node: &'ast Data)
where
    V: Visit<'ast> + ?Sized,
{
    match node {
        Data::Struct(_binding_0) => {
            v.visit_data_struct(_binding_0);
        }
        Data::Enum(_binding_0) => {
            v.visit_data_enum(_binding_0);
        }
        Data::Union(_binding_0) => {
            v.visit_data_union(_binding_0);
        }
    }
}
#[cfg(feature = "derive")]
pub fn visit_data_enum<'ast, V>(v: &mut V, node: &'ast DataEnum)
where
    V: Visit<'ast> + ?Sized,
{
    skip!(node.enum_token);
    skip!(node.brace_token);
    for el in Punctuated::pairs(&node.variants) {
        let it = el.value();
        v.visit_variant(it);
    }
}
#[cfg(feature = "derive")]
pub fn visit_data_struct<'ast, V>(v: &mut V, node: &'ast DataStruct)
where
    V: Visit<'ast> + ?Sized,
{
    skip!(node.struct_token);
    v.visit_fields(&node.fields);
    skip!(node.semi_token);
}
#[cfg(feature = "derive")]
pub fn visit_data_union<'ast, V>(v: &mut V, node: &'ast DataUnion)
where
    V: Visit<'ast> + ?Sized,
{
    skip!(node.union_token);
    v.visit_fields_named(&node.fields);
}
#[cfg(feature = "derive")]
pub fn visit_derive_input<'ast, V>(v: &mut V, node: &'ast DeriveInput)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    v.visit_visibility(&node.vis);
    v.visit_ident(&node.ident);
    v.visit_generics(&node.generics);
    v.visit_data(&node.data);
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_expr<'ast, V>(v: &mut V, node: &'ast Expr)
where
    V: Visit<'ast> + ?Sized,
{
    match node {
        Expr::Array(_binding_0) => {
            full!(v.visit_expr_array(_binding_0));
        }
        Expr::Assign(_binding_0) => {
            full!(v.visit_expr_assign(_binding_0));
        }
        Expr::Async(_binding_0) => {
            full!(v.visit_expr_async(_binding_0));
        }
        Expr::Await(_binding_0) => {
            full!(v.visit_expr_await(_binding_0));
        }
        Expr::Binary(_binding_0) => {
            v.visit_expr_binary(_binding_0);
        }
        Expr::Block(_binding_0) => {
            full!(v.visit_expr_block(_binding_0));
        }
        Expr::Break(_binding_0) => {
            full!(v.visit_expr_break(_binding_0));
        }
        Expr::Call(_binding_0) => {
            v.visit_expr_call(_binding_0);
        }
        Expr::Cast(_binding_0) => {
            v.visit_expr_cast(_binding_0);
        }
        Expr::Closure(_binding_0) => {
            full!(v.visit_expr_closure(_binding_0));
        }
        Expr::Const(_binding_0) => {
            full!(v.visit_expr_const(_binding_0));
        }
        Expr::Continue(_binding_0) => {
            full!(v.visit_expr_continue(_binding_0));
        }
        Expr::Field(_binding_0) => {
            v.visit_expr_field(_binding_0);
        }
        Expr::ForLoop(_binding_0) => {
            full!(v.visit_expr_for_loop(_binding_0));
        }
        Expr::Group(_binding_0) => {
            v.visit_expr_group(_binding_0);
        }
        Expr::If(_binding_0) => {
            full!(v.visit_expr_if(_binding_0));
        }
        Expr::Index(_binding_0) => {
            v.visit_expr_index(_binding_0);
        }
        Expr::Infer(_binding_0) => {
            full!(v.visit_expr_infer(_binding_0));
        }
        Expr::Let(_binding_0) => {
            full!(v.visit_expr_let(_binding_0));
        }
        Expr::Lit(_binding_0) => {
            v.visit_expr_lit(_binding_0);
        }
        Expr::Loop(_binding_0) => {
            full!(v.visit_expr_loop(_binding_0));
        }
        Expr::Macro(_binding_0) => {
            v.visit_expr_macro(_binding_0);
        }
        Expr::Match(_binding_0) => {
            full!(v.visit_expr_match(_binding_0));
        }
        Expr::MethodCall(_binding_0) => {
            full!(v.visit_expr_method_call(_binding_0));
        }
        Expr::Paren(_binding_0) => {
            v.visit_expr_paren(_binding_0);
        }
        Expr::Path(_binding_0) => {
            v.visit_expr_path(_binding_0);
        }
        Expr::Range(_binding_0) => {
            full!(v.visit_expr_range(_binding_0));
        }
        Expr::Reference(_binding_0) => {
            full!(v.visit_expr_reference(_binding_0));
        }
        Expr::Repeat(_binding_0) => {
            full!(v.visit_expr_repeat(_binding_0));
        }
        Expr::Return(_binding_0) => {
            full!(v.visit_expr_return(_binding_0));
        }
        Expr::Struct(_binding_0) => {
            full!(v.visit_expr_struct(_binding_0));
        }
        Expr::Try(_binding_0) => {
            full!(v.visit_expr_try(_binding_0));
        }
        Expr::TryBlock(_binding_0) => {
            full!(v.visit_expr_try_block(_binding_0));
        }
        Expr::Tuple(_binding_0) => {
            full!(v.visit_expr_tuple(_binding_0));
        }
        Expr::Unary(_binding_0) => {
            v.visit_expr_unary(_binding_0);
        }
        Expr::Unsafe(_binding_0) => {
            full!(v.visit_expr_unsafe(_binding_0));
        }
        Expr::Verbatim(_binding_0) => {
            skip!(_binding_0);
        }
        Expr::While(_binding_0) => {
            full!(v.visit_expr_while(_binding_0));
        }
        Expr::Yield(_binding_0) => {
            full!(v.visit_expr_yield(_binding_0));
        }
    }
}
#[cfg(feature = "full")]
pub fn visit_expr_array<'ast, V>(v: &mut V, node: &'ast ExprArray)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    skip!(node.bracket_token);
    for el in Punctuated::pairs(&node.elems) {
        let it = el.value();
        v.visit_expr(it);
    }
}
#[cfg(feature = "full")]
pub fn visit_expr_assign<'ast, V>(v: &mut V, node: &'ast ExprAssign)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    v.visit_expr(&*node.left);
    skip!(node.eq_token);
    v.visit_expr(&*node.right);
}
#[cfg(feature = "full")]
pub fn visit_expr_async<'ast, V>(v: &mut V, node: &'ast ExprAsync)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    skip!(node.async_token);
    skip!(node.capture);
    v.visit_block(&node.block);
}
#[cfg(feature = "full")]
pub fn visit_expr_await<'ast, V>(v: &mut V, node: &'ast ExprAwait)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    v.visit_expr(&*node.base);
    skip!(node.dot_token);
    skip!(node.await_token);
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_expr_binary<'ast, V>(v: &mut V, node: &'ast ExprBinary)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    v.visit_expr(&*node.left);
    v.visit_bin_op(&node.op);
    v.visit_expr(&*node.right);
}
#[cfg(feature = "full")]
pub fn visit_expr_block<'ast, V>(v: &mut V, node: &'ast ExprBlock)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    if let Some(it) = &node.label {
        v.visit_label(it);
    }
    v.visit_block(&node.block);
}
#[cfg(feature = "full")]
pub fn visit_expr_break<'ast, V>(v: &mut V, node: &'ast ExprBreak)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    skip!(node.break_token);
    if let Some(it) = &node.label {
        v.visit_lifetime(it);
    }
    if let Some(it) = &node.expr {
        v.visit_expr(&**it);
    }
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_expr_call<'ast, V>(v: &mut V, node: &'ast ExprCall)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    v.visit_expr(&*node.func);
    skip!(node.paren_token);
    for el in Punctuated::pairs(&node.args) {
        let it = el.value();
        v.visit_expr(it);
    }
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_expr_cast<'ast, V>(v: &mut V, node: &'ast ExprCast)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    v.visit_expr(&*node.expr);
    skip!(node.as_token);
    v.visit_type(&*node.ty);
}
#[cfg(feature = "full")]
pub fn visit_expr_closure<'ast, V>(v: &mut V, node: &'ast ExprClosure)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    if let Some(it) = &node.lifetimes {
        v.visit_bound_lifetimes(it);
    }
    skip!(node.constness);
    skip!(node.movability);
    skip!(node.asyncness);
    skip!(node.capture);
    skip!(node.or1_token);
    for el in Punctuated::pairs(&node.inputs) {
        let it = el.value();
        v.visit_pat(it);
    }
    skip!(node.or2_token);
    v.visit_return_type(&node.output);
    v.visit_expr(&*node.body);
}
#[cfg(feature = "full")]
pub fn visit_expr_const<'ast, V>(v: &mut V, node: &'ast ExprConst)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    skip!(node.const_token);
    v.visit_block(&node.block);
}
#[cfg(feature = "full")]
pub fn visit_expr_continue<'ast, V>(v: &mut V, node: &'ast ExprContinue)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    skip!(node.continue_token);
    if let Some(it) = &node.label {
        v.visit_lifetime(it);
    }
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_expr_field<'ast, V>(v: &mut V, node: &'ast ExprField)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    v.visit_expr(&*node.base);
    skip!(node.dot_token);
    v.visit_member(&node.member);
}
#[cfg(feature = "full")]
pub fn visit_expr_for_loop<'ast, V>(v: &mut V, node: &'ast ExprForLoop)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    if let Some(it) = &node.label {
        v.visit_label(it);
    }
    skip!(node.for_token);
    v.visit_pat(&*node.pat);
    skip!(node.in_token);
    v.visit_expr(&*node.expr);
    v.visit_block(&node.body);
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_expr_group<'ast, V>(v: &mut V, node: &'ast ExprGroup)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    skip!(node.group_token);
    v.visit_expr(&*node.expr);
}
#[cfg(feature = "full")]
pub fn visit_expr_if<'ast, V>(v: &mut V, node: &'ast ExprIf)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    skip!(node.if_token);
    v.visit_expr(&*node.cond);
    v.visit_block(&node.then_branch);
    if let Some(it) = &node.else_branch {
        skip!((it).0);
        v.visit_expr(&*(it).1);
    }
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_expr_index<'ast, V>(v: &mut V, node: &'ast ExprIndex)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    v.visit_expr(&*node.expr);
    skip!(node.bracket_token);
    v.visit_expr(&*node.index);
}
#[cfg(feature = "full")]
pub fn visit_expr_infer<'ast, V>(v: &mut V, node: &'ast ExprInfer)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    skip!(node.underscore_token);
}
#[cfg(feature = "full")]
pub fn visit_expr_let<'ast, V>(v: &mut V, node: &'ast ExprLet)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    skip!(node.let_token);
    v.visit_pat(&*node.pat);
    skip!(node.eq_token);
    v.visit_expr(&*node.expr);
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_expr_lit<'ast, V>(v: &mut V, node: &'ast ExprLit)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    v.visit_lit(&node.lit);
}
#[cfg(feature = "full")]
pub fn visit_expr_loop<'ast, V>(v: &mut V, node: &'ast ExprLoop)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    if let Some(it) = &node.label {
        v.visit_label(it);
    }
    skip!(node.loop_token);
    v.visit_block(&node.body);
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_expr_macro<'ast, V>(v: &mut V, node: &'ast ExprMacro)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    v.visit_macro(&node.mac);
}
#[cfg(feature = "full")]
pub fn visit_expr_match<'ast, V>(v: &mut V, node: &'ast ExprMatch)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    skip!(node.match_token);
    v.visit_expr(&*node.expr);
    skip!(node.brace_token);
    for it in &node.arms {
        v.visit_arm(it);
    }
}
#[cfg(feature = "full")]
pub fn visit_expr_method_call<'ast, V>(v: &mut V, node: &'ast ExprMethodCall)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    v.visit_expr(&*node.receiver);
    skip!(node.dot_token);
    v.visit_ident(&node.method);
    if let Some(it) = &node.turbofish {
        v.visit_angle_bracketed_generic_arguments(it);
    }
    skip!(node.paren_token);
    for el in Punctuated::pairs(&node.args) {
        let it = el.value();
        v.visit_expr(it);
    }
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_expr_paren<'ast, V>(v: &mut V, node: &'ast ExprParen)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    skip!(node.paren_token);
    v.visit_expr(&*node.expr);
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_expr_path<'ast, V>(v: &mut V, node: &'ast ExprPath)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    if let Some(it) = &node.qself {
        v.visit_qself(it);
    }
    v.visit_path(&node.path);
}
#[cfg(feature = "full")]
pub fn visit_expr_range<'ast, V>(v: &mut V, node: &'ast ExprRange)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    if let Some(it) = &node.start {
        v.visit_expr(&**it);
    }
    v.visit_range_limits(&node.limits);
    if let Some(it) = &node.end {
        v.visit_expr(&**it);
    }
}
#[cfg(feature = "full")]
pub fn visit_expr_reference<'ast, V>(v: &mut V, node: &'ast ExprReference)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    skip!(node.and_token);
    skip!(node.mutability);
    v.visit_expr(&*node.expr);
}
#[cfg(feature = "full")]
pub fn visit_expr_repeat<'ast, V>(v: &mut V, node: &'ast ExprRepeat)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    skip!(node.bracket_token);
    v.visit_expr(&*node.expr);
    skip!(node.semi_token);
    v.visit_expr(&*node.len);
}
#[cfg(feature = "full")]
pub fn visit_expr_return<'ast, V>(v: &mut V, node: &'ast ExprReturn)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    skip!(node.return_token);
    if let Some(it) = &node.expr {
        v.visit_expr(&**it);
    }
}
#[cfg(feature = "full")]
pub fn visit_expr_struct<'ast, V>(v: &mut V, node: &'ast ExprStruct)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    if let Some(it) = &node.qself {
        v.visit_qself(it);
    }
    v.visit_path(&node.path);
    skip!(node.brace_token);
    for el in Punctuated::pairs(&node.fields) {
        let it = el.value();
        v.visit_field_value(it);
    }
    skip!(node.dot2_token);
    if let Some(it) = &node.rest {
        v.visit_expr(&**it);
    }
}
#[cfg(feature = "full")]
pub fn visit_expr_try<'ast, V>(v: &mut V, node: &'ast ExprTry)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    v.visit_expr(&*node.expr);
    skip!(node.question_token);
}
#[cfg(feature = "full")]
pub fn visit_expr_try_block<'ast, V>(v: &mut V, node: &'ast ExprTryBlock)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    skip!(node.try_token);
    v.visit_block(&node.block);
}
#[cfg(feature = "full")]
pub fn visit_expr_tuple<'ast, V>(v: &mut V, node: &'ast ExprTuple)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    skip!(node.paren_token);
    for el in Punctuated::pairs(&node.elems) {
        let it = el.value();
        v.visit_expr(it);
    }
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_expr_unary<'ast, V>(v: &mut V, node: &'ast ExprUnary)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    v.visit_un_op(&node.op);
    v.visit_expr(&*node.expr);
}
#[cfg(feature = "full")]
pub fn visit_expr_unsafe<'ast, V>(v: &mut V, node: &'ast ExprUnsafe)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    skip!(node.unsafe_token);
    v.visit_block(&node.block);
}
#[cfg(feature = "full")]
pub fn visit_expr_while<'ast, V>(v: &mut V, node: &'ast ExprWhile)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    if let Some(it) = &node.label {
        v.visit_label(it);
    }
    skip!(node.while_token);
    v.visit_expr(&*node.cond);
    v.visit_block(&node.body);
}
#[cfg(feature = "full")]
pub fn visit_expr_yield<'ast, V>(v: &mut V, node: &'ast ExprYield)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    skip!(node.yield_token);
    if let Some(it) = &node.expr {
        v.visit_expr(&**it);
    }
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_field<'ast, V>(v: &mut V, node: &'ast Field)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    v.visit_visibility(&node.vis);
    v.visit_field_mutability(&node.mutability);
    if let Some(it) = &node.ident {
        v.visit_ident(it);
    }
    skip!(node.colon_token);
    v.visit_type(&node.ty);
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_field_mutability<'ast, V>(v: &mut V, node: &'ast FieldMutability)
where
    V: Visit<'ast> + ?Sized,
{
    match node {
        FieldMutability::None => {}
    }
}
#[cfg(feature = "full")]
pub fn visit_field_pat<'ast, V>(v: &mut V, node: &'ast FieldPat)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    v.visit_member(&node.member);
    skip!(node.colon_token);
    v.visit_pat(&*node.pat);
}
#[cfg(feature = "full")]
pub fn visit_field_value<'ast, V>(v: &mut V, node: &'ast FieldValue)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    v.visit_member(&node.member);
    skip!(node.colon_token);
    v.visit_expr(&node.expr);
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_fields<'ast, V>(v: &mut V, node: &'ast Fields)
where
    V: Visit<'ast> + ?Sized,
{
    match node {
        Fields::Named(_binding_0) => {
            v.visit_fields_named(_binding_0);
        }
        Fields::Unnamed(_binding_0) => {
            v.visit_fields_unnamed(_binding_0);
        }
        Fields::Unit => {}
    }
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_fields_named<'ast, V>(v: &mut V, node: &'ast FieldsNamed)
where
    V: Visit<'ast> + ?Sized,
{
    skip!(node.brace_token);
    for el in Punctuated::pairs(&node.named) {
        let it = el.value();
        v.visit_field(it);
    }
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_fields_unnamed<'ast, V>(v: &mut V, node: &'ast FieldsUnnamed)
where
    V: Visit<'ast> + ?Sized,
{
    skip!(node.paren_token);
    for el in Punctuated::pairs(&node.unnamed) {
        let it = el.value();
        v.visit_field(it);
    }
}
#[cfg(feature = "full")]
pub fn visit_file<'ast, V>(v: &mut V, node: &'ast File)
where
    V: Visit<'ast> + ?Sized,
{
    skip!(node.shebang);
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    for it in &node.items {
        v.visit_item(it);
    }
}
#[cfg(feature = "full")]
pub fn visit_fn_arg<'ast, V>(v: &mut V, node: &'ast FnArg)
where
    V: Visit<'ast> + ?Sized,
{
    match node {
        FnArg::Receiver(_binding_0) => {
            v.visit_receiver(_binding_0);
        }
        FnArg::Typed(_binding_0) => {
            v.visit_pat_type(_binding_0);
        }
    }
}
#[cfg(feature = "full")]
pub fn visit_foreign_item<'ast, V>(v: &mut V, node: &'ast ForeignItem)
where
    V: Visit<'ast> + ?Sized,
{
    match node {
        ForeignItem::Fn(_binding_0) => {
            v.visit_foreign_item_fn(_binding_0);
        }
        ForeignItem::Static(_binding_0) => {
            v.visit_foreign_item_static(_binding_0);
        }
        ForeignItem::Type(_binding_0) => {
            v.visit_foreign_item_type(_binding_0);
        }
        ForeignItem::Macro(_binding_0) => {
            v.visit_foreign_item_macro(_binding_0);
        }
        ForeignItem::Verbatim(_binding_0) => {
            skip!(_binding_0);
        }
    }
}
#[cfg(feature = "full")]
pub fn visit_foreign_item_fn<'ast, V>(v: &mut V, node: &'ast ForeignItemFn)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    v.visit_visibility(&node.vis);
    v.visit_signature(&node.sig);
    skip!(node.semi_token);
}
#[cfg(feature = "full")]
pub fn visit_foreign_item_macro<'ast, V>(v: &mut V, node: &'ast ForeignItemMacro)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    v.visit_macro(&node.mac);
    skip!(node.semi_token);
}
#[cfg(feature = "full")]
pub fn visit_foreign_item_static<'ast, V>(v: &mut V, node: &'ast ForeignItemStatic)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    v.visit_visibility(&node.vis);
    skip!(node.static_token);
    v.visit_static_mutability(&node.mutability);
    v.visit_ident(&node.ident);
    skip!(node.colon_token);
    v.visit_type(&*node.ty);
    skip!(node.semi_token);
}
#[cfg(feature = "full")]
pub fn visit_foreign_item_type<'ast, V>(v: &mut V, node: &'ast ForeignItemType)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    v.visit_visibility(&node.vis);
    skip!(node.type_token);
    v.visit_ident(&node.ident);
    v.visit_generics(&node.generics);
    skip!(node.semi_token);
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_generic_argument<'ast, V>(v: &mut V, node: &'ast GenericArgument)
where
    V: Visit<'ast> + ?Sized,
{
    match node {
        GenericArgument::Lifetime(_binding_0) => {
            v.visit_lifetime(_binding_0);
        }
        GenericArgument::Type(_binding_0) => {
            v.visit_type(_binding_0);
        }
        GenericArgument::Const(_binding_0) => {
            v.visit_expr(_binding_0);
        }
        GenericArgument::AssocType(_binding_0) => {
            v.visit_assoc_type(_binding_0);
        }
        GenericArgument::AssocConst(_binding_0) => {
            v.visit_assoc_const(_binding_0);
        }
        GenericArgument::Constraint(_binding_0) => {
            v.visit_constraint(_binding_0);
        }
    }
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_generic_param<'ast, V>(v: &mut V, node: &'ast GenericParam)
where
    V: Visit<'ast> + ?Sized,
{
    match node {
        GenericParam::Lifetime(_binding_0) => {
            v.visit_lifetime_param(_binding_0);
        }
        GenericParam::Type(_binding_0) => {
            v.visit_type_param(_binding_0);
        }
        GenericParam::Const(_binding_0) => {
            v.visit_const_param(_binding_0);
        }
    }
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_generics<'ast, V>(v: &mut V, node: &'ast Generics)
where
    V: Visit<'ast> + ?Sized,
{
    skip!(node.lt_token);
    for el in Punctuated::pairs(&node.params) {
        let it = el.value();
        v.visit_generic_param(it);
    }
    skip!(node.gt_token);
    if let Some(it) = &node.where_clause {
        v.visit_where_clause(it);
    }
}
pub fn visit_ident<'ast, V>(v: &mut V, node: &'ast Ident)
where
    V: Visit<'ast> + ?Sized,
{
    v.visit_span(&node.span());
}
#[cfg(feature = "full")]
pub fn visit_impl_item<'ast, V>(v: &mut V, node: &'ast ImplItem)
where
    V: Visit<'ast> + ?Sized,
{
    match node {
        ImplItem::Const(_binding_0) => {
            v.visit_impl_item_const(_binding_0);
        }
        ImplItem::Fn(_binding_0) => {
            v.visit_impl_item_fn(_binding_0);
        }
        ImplItem::Type(_binding_0) => {
            v.visit_impl_item_type(_binding_0);
        }
        ImplItem::Macro(_binding_0) => {
            v.visit_impl_item_macro(_binding_0);
        }
        ImplItem::Verbatim(_binding_0) => {
            skip!(_binding_0);
        }
    }
}
#[cfg(feature = "full")]
pub fn visit_impl_item_const<'ast, V>(v: &mut V, node: &'ast ImplItemConst)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    v.visit_visibility(&node.vis);
    skip!(node.defaultness);
    skip!(node.const_token);
    v.visit_ident(&node.ident);
    v.visit_generics(&node.generics);
    skip!(node.colon_token);
    v.visit_type(&node.ty);
    skip!(node.eq_token);
    v.visit_expr(&node.expr);
    skip!(node.semi_token);
}
#[cfg(feature = "full")]
pub fn visit_impl_item_fn<'ast, V>(v: &mut V, node: &'ast ImplItemFn)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    v.visit_visibility(&node.vis);
    skip!(node.defaultness);
    v.visit_signature(&node.sig);
    v.visit_block(&node.block);
}
#[cfg(feature = "full")]
pub fn visit_impl_item_macro<'ast, V>(v: &mut V, node: &'ast ImplItemMacro)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    v.visit_macro(&node.mac);
    skip!(node.semi_token);
}
#[cfg(feature = "full")]
pub fn visit_impl_item_type<'ast, V>(v: &mut V, node: &'ast ImplItemType)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    v.visit_visibility(&node.vis);
    skip!(node.defaultness);
    skip!(node.type_token);
    v.visit_ident(&node.ident);
    v.visit_generics(&node.generics);
    skip!(node.eq_token);
    v.visit_type(&node.ty);
    skip!(node.semi_token);
}
#[cfg(feature = "full")]
pub fn visit_impl_restriction<'ast, V>(v: &mut V, node: &'ast ImplRestriction)
where
    V: Visit<'ast> + ?Sized,
{
    match *node {}
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_index<'ast, V>(v: &mut V, node: &'ast Index)
where
    V: Visit<'ast> + ?Sized,
{
    skip!(node.index);
    v.visit_span(&node.span);
}
#[cfg(feature = "full")]
pub fn visit_item<'ast, V>(v: &mut V, node: &'ast Item)
where
    V: Visit<'ast> + ?Sized,
{
    match node {
        Item::Const(_binding_0) => {
            v.visit_item_const(_binding_0);
        }
        Item::Enum(_binding_0) => {
            v.visit_item_enum(_binding_0);
        }
        Item::ExternCrate(_binding_0) => {
            v.visit_item_extern_crate(_binding_0);
        }
        Item::Fn(_binding_0) => {
            v.visit_item_fn(_binding_0);
        }
        Item::ForeignMod(_binding_0) => {
            v.visit_item_foreign_mod(_binding_0);
        }
        Item::Impl(_binding_0) => {
            v.visit_item_impl(_binding_0);
        }
        Item::Macro(_binding_0) => {
            v.visit_item_macro(_binding_0);
        }
        Item::Mod(_binding_0) => {
            v.visit_item_mod(_binding_0);
        }
        Item::Static(_binding_0) => {
            v.visit_item_static(_binding_0);
        }
        Item::Struct(_binding_0) => {
            v.visit_item_struct(_binding_0);
        }
        Item::Trait(_binding_0) => {
            v.visit_item_trait(_binding_0);
        }
        Item::TraitAlias(_binding_0) => {
            v.visit_item_trait_alias(_binding_0);
        }
        Item::Type(_binding_0) => {
            v.visit_item_type(_binding_0);
        }
        Item::Union(_binding_0) => {
            v.visit_item_union(_binding_0);
        }
        Item::Use(_binding_0) => {
            v.visit_item_use(_binding_0);
        }
        Item::Verbatim(_binding_0) => {
            skip!(_binding_0);
        }
    }
}
#[cfg(feature = "full")]
pub fn visit_item_const<'ast, V>(v: &mut V, node: &'ast ItemConst)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    v.visit_visibility(&node.vis);
    skip!(node.const_token);
    v.visit_ident(&node.ident);
    v.visit_generics(&node.generics);
    skip!(node.colon_token);
    v.visit_type(&*node.ty);
    skip!(node.eq_token);
    v.visit_expr(&*node.expr);
    skip!(node.semi_token);
}
#[cfg(feature = "full")]
pub fn visit_item_enum<'ast, V>(v: &mut V, node: &'ast ItemEnum)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    v.visit_visibility(&node.vis);
    skip!(node.enum_token);
    v.visit_ident(&node.ident);
    v.visit_generics(&node.generics);
    skip!(node.brace_token);
    for el in Punctuated::pairs(&node.variants) {
        let it = el.value();
        v.visit_variant(it);
    }
}
#[cfg(feature = "full")]
pub fn visit_item_extern_crate<'ast, V>(v: &mut V, node: &'ast ItemExternCrate)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    v.visit_visibility(&node.vis);
    skip!(node.extern_token);
    skip!(node.crate_token);
    v.visit_ident(&node.ident);
    if let Some(it) = &node.rename {
        skip!((it).0);
        v.visit_ident(&(it).1);
    }
    skip!(node.semi_token);
}
#[cfg(feature = "full")]
pub fn visit_item_fn<'ast, V>(v: &mut V, node: &'ast ItemFn)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    v.visit_visibility(&node.vis);
    v.visit_signature(&node.sig);
    v.visit_block(&*node.block);
}
#[cfg(feature = "full")]
pub fn visit_item_foreign_mod<'ast, V>(v: &mut V, node: &'ast ItemForeignMod)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    skip!(node.unsafety);
    v.visit_abi(&node.abi);
    skip!(node.brace_token);
    for it in &node.items {
        v.visit_foreign_item(it);
    }
}
#[cfg(feature = "full")]
pub fn visit_item_impl<'ast, V>(v: &mut V, node: &'ast ItemImpl)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    skip!(node.defaultness);
    skip!(node.unsafety);
    skip!(node.impl_token);
    v.visit_generics(&node.generics);
    if let Some(it) = &node.trait_ {
        skip!((it).0);
        v.visit_path(&(it).1);
        skip!((it).2);
    }
    v.visit_type(&*node.self_ty);
    skip!(node.brace_token);
    for it in &node.items {
        v.visit_impl_item(it);
    }
}
#[cfg(feature = "full")]
pub fn visit_item_macro<'ast, V>(v: &mut V, node: &'ast ItemMacro)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    if let Some(it) = &node.ident {
        v.visit_ident(it);
    }
    v.visit_macro(&node.mac);
    skip!(node.semi_token);
}
#[cfg(feature = "full")]
pub fn visit_item_mod<'ast, V>(v: &mut V, node: &'ast ItemMod)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    v.visit_visibility(&node.vis);
    skip!(node.unsafety);
    skip!(node.mod_token);
    v.visit_ident(&node.ident);
    if let Some(it) = &node.content {
        skip!((it).0);
        for it in &(it).1 {
            v.visit_item(it);
        }
    }
    skip!(node.semi);
}
#[cfg(feature = "full")]
pub fn visit_item_static<'ast, V>(v: &mut V, node: &'ast ItemStatic)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    v.visit_visibility(&node.vis);
    skip!(node.static_token);
    v.visit_static_mutability(&node.mutability);
    v.visit_ident(&node.ident);
    skip!(node.colon_token);
    v.visit_type(&*node.ty);
    skip!(node.eq_token);
    v.visit_expr(&*node.expr);
    skip!(node.semi_token);
}
#[cfg(feature = "full")]
pub fn visit_item_struct<'ast, V>(v: &mut V, node: &'ast ItemStruct)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    v.visit_visibility(&node.vis);
    skip!(node.struct_token);
    v.visit_ident(&node.ident);
    v.visit_generics(&node.generics);
    v.visit_fields(&node.fields);
    skip!(node.semi_token);
}
#[cfg(feature = "full")]
pub fn visit_item_trait<'ast, V>(v: &mut V, node: &'ast ItemTrait)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    v.visit_visibility(&node.vis);
    skip!(node.unsafety);
    skip!(node.auto_token);
    if let Some(it) = &node.restriction {
        v.visit_impl_restriction(it);
    }
    skip!(node.trait_token);
    v.visit_ident(&node.ident);
    v.visit_generics(&node.generics);
    skip!(node.colon_token);
    for el in Punctuated::pairs(&node.supertraits) {
        let it = el.value();
        v.visit_type_param_bound(it);
    }
    skip!(node.brace_token);
    for it in &node.items {
        v.visit_trait_item(it);
    }
}
#[cfg(feature = "full")]
pub fn visit_item_trait_alias<'ast, V>(v: &mut V, node: &'ast ItemTraitAlias)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    v.visit_visibility(&node.vis);
    skip!(node.trait_token);
    v.visit_ident(&node.ident);
    v.visit_generics(&node.generics);
    skip!(node.eq_token);
    for el in Punctuated::pairs(&node.bounds) {
        let it = el.value();
        v.visit_type_param_bound(it);
    }
    skip!(node.semi_token);
}
#[cfg(feature = "full")]
pub fn visit_item_type<'ast, V>(v: &mut V, node: &'ast ItemType)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    v.visit_visibility(&node.vis);
    skip!(node.type_token);
    v.visit_ident(&node.ident);
    v.visit_generics(&node.generics);
    skip!(node.eq_token);
    v.visit_type(&*node.ty);
    skip!(node.semi_token);
}
#[cfg(feature = "full")]
pub fn visit_item_union<'ast, V>(v: &mut V, node: &'ast ItemUnion)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    v.visit_visibility(&node.vis);
    skip!(node.union_token);
    v.visit_ident(&node.ident);
    v.visit_generics(&node.generics);
    v.visit_fields_named(&node.fields);
}
#[cfg(feature = "full")]
pub fn visit_item_use<'ast, V>(v: &mut V, node: &'ast ItemUse)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    v.visit_visibility(&node.vis);
    skip!(node.use_token);
    skip!(node.leading_colon);
    v.visit_use_tree(&node.tree);
    skip!(node.semi_token);
}
#[cfg(feature = "full")]
pub fn visit_label<'ast, V>(v: &mut V, node: &'ast Label)
where
    V: Visit<'ast> + ?Sized,
{
    v.visit_lifetime(&node.name);
    skip!(node.colon_token);
}
pub fn visit_lifetime<'ast, V>(v: &mut V, node: &'ast Lifetime)
where
    V: Visit<'ast> + ?Sized,
{
    v.visit_span(&node.apostrophe);
    v.visit_ident(&node.ident);
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_lifetime_param<'ast, V>(v: &mut V, node: &'ast LifetimeParam)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    v.visit_lifetime(&node.lifetime);
    skip!(node.colon_token);
    for el in Punctuated::pairs(&node.bounds) {
        let it = el.value();
        v.visit_lifetime(it);
    }
}
pub fn visit_lit<'ast, V>(v: &mut V, node: &'ast Lit)
where
    V: Visit<'ast> + ?Sized,
{
    match node {
        Lit::Str(_binding_0) => {
            v.visit_lit_str(_binding_0);
        }
        Lit::ByteStr(_binding_0) => {
            v.visit_lit_byte_str(_binding_0);
        }
        Lit::Byte(_binding_0) => {
            v.visit_lit_byte(_binding_0);
        }
        Lit::Char(_binding_0) => {
            v.visit_lit_char(_binding_0);
        }
        Lit::Int(_binding_0) => {
            v.visit_lit_int(_binding_0);
        }
        Lit::Float(_binding_0) => {
            v.visit_lit_float(_binding_0);
        }
        Lit::Bool(_binding_0) => {
            v.visit_lit_bool(_binding_0);
        }
        Lit::Verbatim(_binding_0) => {
            skip!(_binding_0);
        }
    }
}
pub fn visit_lit_bool<'ast, V>(v: &mut V, node: &'ast LitBool)
where
    V: Visit<'ast> + ?Sized,
{
    skip!(node.value);
    v.visit_span(&node.span);
}
pub fn visit_lit_byte<'ast, V>(v: &mut V, node: &'ast LitByte)
where
    V: Visit<'ast> + ?Sized,
{}
pub fn visit_lit_byte_str<'ast, V>(v: &mut V, node: &'ast LitByteStr)
where
    V: Visit<'ast> + ?Sized,
{}
pub fn visit_lit_char<'ast, V>(v: &mut V, node: &'ast LitChar)
where
    V: Visit<'ast> + ?Sized,
{}
pub fn visit_lit_float<'ast, V>(v: &mut V, node: &'ast LitFloat)
where
    V: Visit<'ast> + ?Sized,
{}
pub fn visit_lit_int<'ast, V>(v: &mut V, node: &'ast LitInt)
where
    V: Visit<'ast> + ?Sized,
{}
pub fn visit_lit_str<'ast, V>(v: &mut V, node: &'ast LitStr)
where
    V: Visit<'ast> + ?Sized,
{}
#[cfg(feature = "full")]
pub fn visit_local<'ast, V>(v: &mut V, node: &'ast Local)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    skip!(node.let_token);
    v.visit_pat(&node.pat);
    if let Some(it) = &node.init {
        v.visit_local_init(it);
    }
    skip!(node.semi_token);
}
#[cfg(feature = "full")]
pub fn visit_local_init<'ast, V>(v: &mut V, node: &'ast LocalInit)
where
    V: Visit<'ast> + ?Sized,
{
    skip!(node.eq_token);
    v.visit_expr(&*node.expr);
    if let Some(it) = &node.diverge {
        skip!((it).0);
        v.visit_expr(&*(it).1);
    }
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_macro<'ast, V>(v: &mut V, node: &'ast Macro)
where
    V: Visit<'ast> + ?Sized,
{
    v.visit_path(&node.path);
    skip!(node.bang_token);
    v.visit_macro_delimiter(&node.delimiter);
    skip!(node.tokens);
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_macro_delimiter<'ast, V>(v: &mut V, node: &'ast MacroDelimiter)
where
    V: Visit<'ast> + ?Sized,
{
    match node {
        MacroDelimiter::Paren(_binding_0) => {
            skip!(_binding_0);
        }
        MacroDelimiter::Brace(_binding_0) => {
            skip!(_binding_0);
        }
        MacroDelimiter::Bracket(_binding_0) => {
            skip!(_binding_0);
        }
    }
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_member<'ast, V>(v: &mut V, node: &'ast Member)
where
    V: Visit<'ast> + ?Sized,
{
    match node {
        Member::Named(_binding_0) => {
            v.visit_ident(_binding_0);
        }
        Member::Unnamed(_binding_0) => {
            v.visit_index(_binding_0);
        }
    }
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_meta<'ast, V>(v: &mut V, node: &'ast Meta)
where
    V: Visit<'ast> + ?Sized,
{
    match node {
        Meta::Path(_binding_0) => {
            v.visit_path(_binding_0);
        }
        Meta::List(_binding_0) => {
            v.visit_meta_list(_binding_0);
        }
        Meta::NameValue(_binding_0) => {
            v.visit_meta_name_value(_binding_0);
        }
    }
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_meta_list<'ast, V>(v: &mut V, node: &'ast MetaList)
where
    V: Visit<'ast> + ?Sized,
{
    v.visit_path(&node.path);
    v.visit_macro_delimiter(&node.delimiter);
    skip!(node.tokens);
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_meta_name_value<'ast, V>(v: &mut V, node: &'ast MetaNameValue)
where
    V: Visit<'ast> + ?Sized,
{
    v.visit_path(&node.path);
    skip!(node.eq_token);
    v.visit_expr(&node.value);
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_parenthesized_generic_arguments<'ast, V>(
    v: &mut V,
    node: &'ast ParenthesizedGenericArguments,
)
where
    V: Visit<'ast> + ?Sized,
{
    skip!(node.paren_token);
    for el in Punctuated::pairs(&node.inputs) {
        let it = el.value();
        v.visit_type(it);
    }
    v.visit_return_type(&node.output);
}
#[cfg(feature = "full")]
pub fn visit_pat<'ast, V>(v: &mut V, node: &'ast Pat)
where
    V: Visit<'ast> + ?Sized,
{
    match node {
        Pat::Const(_binding_0) => {
            v.visit_expr_const(_binding_0);
        }
        Pat::Ident(_binding_0) => {
            v.visit_pat_ident(_binding_0);
        }
        Pat::Lit(_binding_0) => {
            v.visit_expr_lit(_binding_0);
        }
        Pat::Macro(_binding_0) => {
            v.visit_expr_macro(_binding_0);
        }
        Pat::Or(_binding_0) => {
            v.visit_pat_or(_binding_0);
        }
        Pat::Paren(_binding_0) => {
            v.visit_pat_paren(_binding_0);
        }
        Pat::Path(_binding_0) => {
            v.visit_expr_path(_binding_0);
        }
        Pat::Range(_binding_0) => {
            v.visit_expr_range(_binding_0);
        }
        Pat::Reference(_binding_0) => {
            v.visit_pat_reference(_binding_0);
        }
        Pat::Rest(_binding_0) => {
            v.visit_pat_rest(_binding_0);
        }
        Pat::Slice(_binding_0) => {
            v.visit_pat_slice(_binding_0);
        }
        Pat::Struct(_binding_0) => {
            v.visit_pat_struct(_binding_0);
        }
        Pat::Tuple(_binding_0) => {
            v.visit_pat_tuple(_binding_0);
        }
        Pat::TupleStruct(_binding_0) => {
            v.visit_pat_tuple_struct(_binding_0);
        }
        Pat::Type(_binding_0) => {
            v.visit_pat_type(_binding_0);
        }
        Pat::Verbatim(_binding_0) => {
            skip!(_binding_0);
        }
        Pat::Wild(_binding_0) => {
            v.visit_pat_wild(_binding_0);
        }
    }
}
#[cfg(feature = "full")]
pub fn visit_pat_ident<'ast, V>(v: &mut V, node: &'ast PatIdent)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    skip!(node.by_ref);
    skip!(node.mutability);
    v.visit_ident(&node.ident);
    if let Some(it) = &node.subpat {
        skip!((it).0);
        v.visit_pat(&*(it).1);
    }
}
#[cfg(feature = "full")]
pub fn visit_pat_or<'ast, V>(v: &mut V, node: &'ast PatOr)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    skip!(node.leading_vert);
    for el in Punctuated::pairs(&node.cases) {
        let it = el.value();
        v.visit_pat(it);
    }
}
#[cfg(feature = "full")]
pub fn visit_pat_paren<'ast, V>(v: &mut V, node: &'ast PatParen)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    skip!(node.paren_token);
    v.visit_pat(&*node.pat);
}
#[cfg(feature = "full")]
pub fn visit_pat_reference<'ast, V>(v: &mut V, node: &'ast PatReference)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    skip!(node.and_token);
    skip!(node.mutability);
    v.visit_pat(&*node.pat);
}
#[cfg(feature = "full")]
pub fn visit_pat_rest<'ast, V>(v: &mut V, node: &'ast PatRest)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    skip!(node.dot2_token);
}
#[cfg(feature = "full")]
pub fn visit_pat_slice<'ast, V>(v: &mut V, node: &'ast PatSlice)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    skip!(node.bracket_token);
    for el in Punctuated::pairs(&node.elems) {
        let it = el.value();
        v.visit_pat(it);
    }
}
#[cfg(feature = "full")]
pub fn visit_pat_struct<'ast, V>(v: &mut V, node: &'ast PatStruct)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    if let Some(it) = &node.qself {
        v.visit_qself(it);
    }
    v.visit_path(&node.path);
    skip!(node.brace_token);
    for el in Punctuated::pairs(&node.fields) {
        let it = el.value();
        v.visit_field_pat(it);
    }
    if let Some(it) = &node.rest {
        v.visit_pat_rest(it);
    }
}
#[cfg(feature = "full")]
pub fn visit_pat_tuple<'ast, V>(v: &mut V, node: &'ast PatTuple)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    skip!(node.paren_token);
    for el in Punctuated::pairs(&node.elems) {
        let it = el.value();
        v.visit_pat(it);
    }
}
#[cfg(feature = "full")]
pub fn visit_pat_tuple_struct<'ast, V>(v: &mut V, node: &'ast PatTupleStruct)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    if let Some(it) = &node.qself {
        v.visit_qself(it);
    }
    v.visit_path(&node.path);
    skip!(node.paren_token);
    for el in Punctuated::pairs(&node.elems) {
        let it = el.value();
        v.visit_pat(it);
    }
}
#[cfg(feature = "full")]
pub fn visit_pat_type<'ast, V>(v: &mut V, node: &'ast PatType)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    v.visit_pat(&*node.pat);
    skip!(node.colon_token);
    v.visit_type(&*node.ty);
}
#[cfg(feature = "full")]
pub fn visit_pat_wild<'ast, V>(v: &mut V, node: &'ast PatWild)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    skip!(node.underscore_token);
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_path<'ast, V>(v: &mut V, node: &'ast Path)
where
    V: Visit<'ast> + ?Sized,
{
    skip!(node.leading_colon);
    for el in Punctuated::pairs(&node.segments) {
        let it = el.value();
        v.visit_path_segment(it);
    }
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_path_arguments<'ast, V>(v: &mut V, node: &'ast PathArguments)
where
    V: Visit<'ast> + ?Sized,
{
    match node {
        PathArguments::None => {}
        PathArguments::AngleBracketed(_binding_0) => {
            v.visit_angle_bracketed_generic_arguments(_binding_0);
        }
        PathArguments::Parenthesized(_binding_0) => {
            v.visit_parenthesized_generic_arguments(_binding_0);
        }
    }
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_path_segment<'ast, V>(v: &mut V, node: &'ast PathSegment)
where
    V: Visit<'ast> + ?Sized,
{
    v.visit_ident(&node.ident);
    v.visit_path_arguments(&node.arguments);
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_predicate_lifetime<'ast, V>(v: &mut V, node: &'ast PredicateLifetime)
where
    V: Visit<'ast> + ?Sized,
{
    v.visit_lifetime(&node.lifetime);
    skip!(node.colon_token);
    for el in Punctuated::pairs(&node.bounds) {
        let it = el.value();
        v.visit_lifetime(it);
    }
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_predicate_type<'ast, V>(v: &mut V, node: &'ast PredicateType)
where
    V: Visit<'ast> + ?Sized,
{
    if let Some(it) = &node.lifetimes {
        v.visit_bound_lifetimes(it);
    }
    v.visit_type(&node.bounded_ty);
    skip!(node.colon_token);
    for el in Punctuated::pairs(&node.bounds) {
        let it = el.value();
        v.visit_type_param_bound(it);
    }
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_qself<'ast, V>(v: &mut V, node: &'ast QSelf)
where
    V: Visit<'ast> + ?Sized,
{
    skip!(node.lt_token);
    v.visit_type(&*node.ty);
    skip!(node.position);
    skip!(node.as_token);
    skip!(node.gt_token);
}
#[cfg(feature = "full")]
pub fn visit_range_limits<'ast, V>(v: &mut V, node: &'ast RangeLimits)
where
    V: Visit<'ast> + ?Sized,
{
    match node {
        RangeLimits::HalfOpen(_binding_0) => {
            skip!(_binding_0);
        }
        RangeLimits::Closed(_binding_0) => {
            skip!(_binding_0);
        }
    }
}
#[cfg(feature = "full")]
pub fn visit_receiver<'ast, V>(v: &mut V, node: &'ast Receiver)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    if let Some(it) = &node.reference {
        skip!((it).0);
        if let Some(it) = &(it).1 {
            v.visit_lifetime(it);
        }
    }
    skip!(node.mutability);
    skip!(node.self_token);
    skip!(node.colon_token);
    v.visit_type(&*node.ty);
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_return_type<'ast, V>(v: &mut V, node: &'ast ReturnType)
where
    V: Visit<'ast> + ?Sized,
{
    match node {
        ReturnType::Default => {}
        ReturnType::Type(_binding_0, _binding_1) => {
            skip!(_binding_0);
            v.visit_type(&**_binding_1);
        }
    }
}
#[cfg(feature = "full")]
pub fn visit_signature<'ast, V>(v: &mut V, node: &'ast Signature)
where
    V: Visit<'ast> + ?Sized,
{
    skip!(node.constness);
    skip!(node.asyncness);
    skip!(node.unsafety);
    if let Some(it) = &node.abi {
        v.visit_abi(it);
    }
    skip!(node.fn_token);
    v.visit_ident(&node.ident);
    v.visit_generics(&node.generics);
    skip!(node.paren_token);
    for el in Punctuated::pairs(&node.inputs) {
        let it = el.value();
        v.visit_fn_arg(it);
    }
    if let Some(it) = &node.variadic {
        v.visit_variadic(it);
    }
    v.visit_return_type(&node.output);
}
pub fn visit_span<'ast, V>(v: &mut V, node: &Span)
where
    V: Visit<'ast> + ?Sized,
{}
#[cfg(feature = "full")]
pub fn visit_static_mutability<'ast, V>(v: &mut V, node: &'ast StaticMutability)
where
    V: Visit<'ast> + ?Sized,
{
    match node {
        StaticMutability::Mut(_binding_0) => {
            skip!(_binding_0);
        }
        StaticMutability::None => {}
    }
}
#[cfg(feature = "full")]
pub fn visit_stmt<'ast, V>(v: &mut V, node: &'ast Stmt)
where
    V: Visit<'ast> + ?Sized,
{
    match node {
        Stmt::Local(_binding_0) => {
            v.visit_local(_binding_0);
        }
        Stmt::Item(_binding_0) => {
            v.visit_item(_binding_0);
        }
        Stmt::Expr(_binding_0, _binding_1) => {
            v.visit_expr(_binding_0);
            skip!(_binding_1);
        }
        Stmt::Macro(_binding_0) => {
            v.visit_stmt_macro(_binding_0);
        }
    }
}
#[cfg(feature = "full")]
pub fn visit_stmt_macro<'ast, V>(v: &mut V, node: &'ast StmtMacro)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    v.visit_macro(&node.mac);
    skip!(node.semi_token);
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_trait_bound<'ast, V>(v: &mut V, node: &'ast TraitBound)
where
    V: Visit<'ast> + ?Sized,
{
    skip!(node.paren_token);
    v.visit_trait_bound_modifier(&node.modifier);
    if let Some(it) = &node.lifetimes {
        v.visit_bound_lifetimes(it);
    }
    v.visit_path(&node.path);
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_trait_bound_modifier<'ast, V>(v: &mut V, node: &'ast TraitBoundModifier)
where
    V: Visit<'ast> + ?Sized,
{
    match node {
        TraitBoundModifier::None => {}
        TraitBoundModifier::Maybe(_binding_0) => {
            skip!(_binding_0);
        }
    }
}
#[cfg(feature = "full")]
pub fn visit_trait_item<'ast, V>(v: &mut V, node: &'ast TraitItem)
where
    V: Visit<'ast> + ?Sized,
{
    match node {
        TraitItem::Const(_binding_0) => {
            v.visit_trait_item_const(_binding_0);
        }
        TraitItem::Fn(_binding_0) => {
            v.visit_trait_item_fn(_binding_0);
        }
        TraitItem::Type(_binding_0) => {
            v.visit_trait_item_type(_binding_0);
        }
        TraitItem::Macro(_binding_0) => {
            v.visit_trait_item_macro(_binding_0);
        }
        TraitItem::Verbatim(_binding_0) => {
            skip!(_binding_0);
        }
    }
}
#[cfg(feature = "full")]
pub fn visit_trait_item_const<'ast, V>(v: &mut V, node: &'ast TraitItemConst)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    skip!(node.const_token);
    v.visit_ident(&node.ident);
    v.visit_generics(&node.generics);
    skip!(node.colon_token);
    v.visit_type(&node.ty);
    if let Some(it) = &node.default {
        skip!((it).0);
        v.visit_expr(&(it).1);
    }
    skip!(node.semi_token);
}
#[cfg(feature = "full")]
pub fn visit_trait_item_fn<'ast, V>(v: &mut V, node: &'ast TraitItemFn)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    v.visit_signature(&node.sig);
    if let Some(it) = &node.default {
        v.visit_block(it);
    }
    skip!(node.semi_token);
}
#[cfg(feature = "full")]
pub fn visit_trait_item_macro<'ast, V>(v: &mut V, node: &'ast TraitItemMacro)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    v.visit_macro(&node.mac);
    skip!(node.semi_token);
}
#[cfg(feature = "full")]
pub fn visit_trait_item_type<'ast, V>(v: &mut V, node: &'ast TraitItemType)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    skip!(node.type_token);
    v.visit_ident(&node.ident);
    v.visit_generics(&node.generics);
    skip!(node.colon_token);
    for el in Punctuated::pairs(&node.bounds) {
        let it = el.value();
        v.visit_type_param_bound(it);
    }
    if let Some(it) = &node.default {
        skip!((it).0);
        v.visit_type(&(it).1);
    }
    skip!(node.semi_token);
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_type<'ast, V>(v: &mut V, node: &'ast Type)
where
    V: Visit<'ast> + ?Sized,
{
    match node {
        Type::Array(_binding_0) => {
            v.visit_type_array(_binding_0);
        }
        Type::BareFn(_binding_0) => {
            v.visit_type_bare_fn(_binding_0);
        }
        Type::Group(_binding_0) => {
            v.visit_type_group(_binding_0);
        }
        Type::ImplTrait(_binding_0) => {
            v.visit_type_impl_trait(_binding_0);
        }
        Type::Infer(_binding_0) => {
            v.visit_type_infer(_binding_0);
        }
        Type::Macro(_binding_0) => {
            v.visit_type_macro(_binding_0);
        }
        Type::Never(_binding_0) => {
            v.visit_type_never(_binding_0);
        }
        Type::Paren(_binding_0) => {
            v.visit_type_paren(_binding_0);
        }
        Type::Path(_binding_0) => {
            v.visit_type_path(_binding_0);
        }
        Type::Ptr(_binding_0) => {
            v.visit_type_ptr(_binding_0);
        }
        Type::Reference(_binding_0) => {
            v.visit_type_reference(_binding_0);
        }
        Type::Slice(_binding_0) => {
            v.visit_type_slice(_binding_0);
        }
        Type::TraitObject(_binding_0) => {
            v.visit_type_trait_object(_binding_0);
        }
        Type::Tuple(_binding_0) => {
            v.visit_type_tuple(_binding_0);
        }
        Type::Verbatim(_binding_0) => {
            skip!(_binding_0);
        }
    }
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_type_array<'ast, V>(v: &mut V, node: &'ast TypeArray)
where
    V: Visit<'ast> + ?Sized,
{
    skip!(node.bracket_token);
    v.visit_type(&*node.elem);
    skip!(node.semi_token);
    v.visit_expr(&node.len);
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_type_bare_fn<'ast, V>(v: &mut V, node: &'ast TypeBareFn)
where
    V: Visit<'ast> + ?Sized,
{
    if let Some(it) = &node.lifetimes {
        v.visit_bound_lifetimes(it);
    }
    skip!(node.unsafety);
    if let Some(it) = &node.abi {
        v.visit_abi(it);
    }
    skip!(node.fn_token);
    skip!(node.paren_token);
    for el in Punctuated::pairs(&node.inputs) {
        let it = el.value();
        v.visit_bare_fn_arg(it);
    }
    if let Some(it) = &node.variadic {
        v.visit_bare_variadic(it);
    }
    v.visit_return_type(&node.output);
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_type_group<'ast, V>(v: &mut V, node: &'ast TypeGroup)
where
    V: Visit<'ast> + ?Sized,
{
    skip!(node.group_token);
    v.visit_type(&*node.elem);
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_type_impl_trait<'ast, V>(v: &mut V, node: &'ast TypeImplTrait)
where
    V: Visit<'ast> + ?Sized,
{
    skip!(node.impl_token);
    for el in Punctuated::pairs(&node.bounds) {
        let it = el.value();
        v.visit_type_param_bound(it);
    }
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_type_infer<'ast, V>(v: &mut V, node: &'ast TypeInfer)
where
    V: Visit<'ast> + ?Sized,
{
    skip!(node.underscore_token);
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_type_macro<'ast, V>(v: &mut V, node: &'ast TypeMacro)
where
    V: Visit<'ast> + ?Sized,
{
    v.visit_macro(&node.mac);
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_type_never<'ast, V>(v: &mut V, node: &'ast TypeNever)
where
    V: Visit<'ast> + ?Sized,
{
    skip!(node.bang_token);
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_type_param<'ast, V>(v: &mut V, node: &'ast TypeParam)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    v.visit_ident(&node.ident);
    skip!(node.colon_token);
    for el in Punctuated::pairs(&node.bounds) {
        let it = el.value();
        v.visit_type_param_bound(it);
    }
    skip!(node.eq_token);
    if let Some(it) = &node.default {
        v.visit_type(it);
    }
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_type_param_bound<'ast, V>(v: &mut V, node: &'ast TypeParamBound)
where
    V: Visit<'ast> + ?Sized,
{
    match node {
        TypeParamBound::Trait(_binding_0) => {
            v.visit_trait_bound(_binding_0);
        }
        TypeParamBound::Lifetime(_binding_0) => {
            v.visit_lifetime(_binding_0);
        }
        TypeParamBound::Verbatim(_binding_0) => {
            skip!(_binding_0);
        }
    }
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_type_paren<'ast, V>(v: &mut V, node: &'ast TypeParen)
where
    V: Visit<'ast> + ?Sized,
{
    skip!(node.paren_token);
    v.visit_type(&*node.elem);
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_type_path<'ast, V>(v: &mut V, node: &'ast TypePath)
where
    V: Visit<'ast> + ?Sized,
{
    if let Some(it) = &node.qself {
        v.visit_qself(it);
    }
    v.visit_path(&node.path);
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_type_ptr<'ast, V>(v: &mut V, node: &'ast TypePtr)
where
    V: Visit<'ast> + ?Sized,
{
    skip!(node.star_token);
    skip!(node.const_token);
    skip!(node.mutability);
    v.visit_type(&*node.elem);
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_type_reference<'ast, V>(v: &mut V, node: &'ast TypeReference)
where
    V: Visit<'ast> + ?Sized,
{
    skip!(node.and_token);
    if let Some(it) = &node.lifetime {
        v.visit_lifetime(it);
    }
    skip!(node.mutability);
    v.visit_type(&*node.elem);
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_type_slice<'ast, V>(v: &mut V, node: &'ast TypeSlice)
where
    V: Visit<'ast> + ?Sized,
{
    skip!(node.bracket_token);
    v.visit_type(&*node.elem);
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_type_trait_object<'ast, V>(v: &mut V, node: &'ast TypeTraitObject)
where
    V: Visit<'ast> + ?Sized,
{
    skip!(node.dyn_token);
    for el in Punctuated::pairs(&node.bounds) {
        let it = el.value();
        v.visit_type_param_bound(it);
    }
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_type_tuple<'ast, V>(v: &mut V, node: &'ast TypeTuple)
where
    V: Visit<'ast> + ?Sized,
{
    skip!(node.paren_token);
    for el in Punctuated::pairs(&node.elems) {
        let it = el.value();
        v.visit_type(it);
    }
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_un_op<'ast, V>(v: &mut V, node: &'ast UnOp)
where
    V: Visit<'ast> + ?Sized,
{
    match node {
        UnOp::Deref(_binding_0) => {
            skip!(_binding_0);
        }
        UnOp::Not(_binding_0) => {
            skip!(_binding_0);
        }
        UnOp::Neg(_binding_0) => {
            skip!(_binding_0);
        }
    }
}
#[cfg(feature = "full")]
pub fn visit_use_glob<'ast, V>(v: &mut V, node: &'ast UseGlob)
where
    V: Visit<'ast> + ?Sized,
{
    skip!(node.star_token);
}
#[cfg(feature = "full")]
pub fn visit_use_group<'ast, V>(v: &mut V, node: &'ast UseGroup)
where
    V: Visit<'ast> + ?Sized,
{
    skip!(node.brace_token);
    for el in Punctuated::pairs(&node.items) {
        let it = el.value();
        v.visit_use_tree(it);
    }
}
#[cfg(feature = "full")]
pub fn visit_use_name<'ast, V>(v: &mut V, node: &'ast UseName)
where
    V: Visit<'ast> + ?Sized,
{
    v.visit_ident(&node.ident);
}
#[cfg(feature = "full")]
pub fn visit_use_path<'ast, V>(v: &mut V, node: &'ast UsePath)
where
    V: Visit<'ast> + ?Sized,
{
    v.visit_ident(&node.ident);
    skip!(node.colon2_token);
    v.visit_use_tree(&*node.tree);
}
#[cfg(feature = "full")]
pub fn visit_use_rename<'ast, V>(v: &mut V, node: &'ast UseRename)
where
    V: Visit<'ast> + ?Sized,
{
    v.visit_ident(&node.ident);
    skip!(node.as_token);
    v.visit_ident(&node.rename);
}
#[cfg(feature = "full")]
pub fn visit_use_tree<'ast, V>(v: &mut V, node: &'ast UseTree)
where
    V: Visit<'ast> + ?Sized,
{
    match node {
        UseTree::Path(_binding_0) => {
            v.visit_use_path(_binding_0);
        }
        UseTree::Name(_binding_0) => {
            v.visit_use_name(_binding_0);
        }
        UseTree::Rename(_binding_0) => {
            v.visit_use_rename(_binding_0);
        }
        UseTree::Glob(_binding_0) => {
            v.visit_use_glob(_binding_0);
        }
        UseTree::Group(_binding_0) => {
            v.visit_use_group(_binding_0);
        }
    }
}
#[cfg(feature = "full")]
pub fn visit_variadic<'ast, V>(v: &mut V, node: &'ast Variadic)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    if let Some(it) = &node.pat {
        v.visit_pat(&*(it).0);
        skip!((it).1);
    }
    skip!(node.dots);
    skip!(node.comma);
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_variant<'ast, V>(v: &mut V, node: &'ast Variant)
where
    V: Visit<'ast> + ?Sized,
{
    for it in &node.attrs {
        v.visit_attribute(it);
    }
    v.visit_ident(&node.ident);
    v.visit_fields(&node.fields);
    if let Some(it) = &node.discriminant {
        skip!((it).0);
        v.visit_expr(&(it).1);
    }
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_vis_restricted<'ast, V>(v: &mut V, node: &'ast VisRestricted)
where
    V: Visit<'ast> + ?Sized,
{
    skip!(node.pub_token);
    skip!(node.paren_token);
    skip!(node.in_token);
    v.visit_path(&*node.path);
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_visibility<'ast, V>(v: &mut V, node: &'ast Visibility)
where
    V: Visit<'ast> + ?Sized,
{
    match node {
        Visibility::Public(_binding_0) => {
            skip!(_binding_0);
        }
        Visibility::Restricted(_binding_0) => {
            v.visit_vis_restricted(_binding_0);
        }
        Visibility::Inherited => {}
    }
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_where_clause<'ast, V>(v: &mut V, node: &'ast WhereClause)
where
    V: Visit<'ast> + ?Sized,
{
    skip!(node.where_token);
    for el in Punctuated::pairs(&node.predicates) {
        let it = el.value();
        v.visit_where_predicate(it);
    }
}
#[cfg(any(feature = "derive", feature = "full"))]
pub fn visit_where_predicate<'ast, V>(v: &mut V, node: &'ast WherePredicate)
where
    V: Visit<'ast> + ?Sized,
{
    match node {
        WherePredicate::Lifetime(_binding_0) => {
            v.visit_predicate_lifetime(_binding_0);
        }
        WherePredicate::Type(_binding_0) => {
            v.visit_predicate_type(_binding_0);
        }
    }
}
