% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zscorer.R
\docType{data}
\name{wgsrData}
\alias{wgsrData}
\title{wgsrData}
\format{A data frame with 6 columns and 28654 rows.
\describe{
\item{\code{index}}{One of BMI-for-age (\code{bfa}), head circumference
    for-age (\code{hca}), height-for-age (\code{hfa}); length-for-age (\code{lfa}),
    MUAC-for-age (\code{mfa}), subscapular skinfold-for-age (\code{ssa}),
    triceps skinfold-for-age (\code{tsa}), weight-for-age (\code{wfa}),
    weight-for-length (\code{wfl}) or weight-for-height (\code{wfh})
    anthropometric indicators}
\item{\code{sex}}{Sex of child (1 = Male; 2 = Female)}
\item{\code{given}}{Variable to which standardisation is to be made. For
    \code{wfa}, \code{hfa}, \code{bfa}, \code{hca}, \code{lfa}, \code{mfa},
    \code{ssa} and \code{tsa}, \code{given} is age in months. For \code{whl},
    \code{wfh}, \code{given} is height or length in cm}
\item{\code{l}}{\code{L} component of the LMS method for normalising growth
    centile standards. \code{L} is the trend in the optimal power to obtain
    normality}
\item{\code{m}}{\code{M} component of the LMS method for normalising growth
    centile standards. \code{M} is the trend in the mean}
\item{\code{s}}{\code{S} component of the LMS method for normalising growth
    centile standards. \code{S} is the trend in the coefficient of variation}
}}
\source{
\cite{World Health Organization. WHO Child Growth Standards:
Length/Height-for-age, Weight-for-age, Weight-for-length, Weight-for-height,
and Body Mass Index-for age: Methods and Development. 1st ed.
World Health Organization; 2006.}
}
\usage{
wgsrData
}
\description{
This is an expanded version of the \code{wgsData} which includes additional
anthropometric indices found in the World Health Organization (WHO) Growth
Reference (2006) data
}
\keyword{datasets}
