% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permutation.scale.R
\name{permutation.scale}
\alias{permutation.scale}
\title{Permute the dataset by the largest absolute value in each eigenvector, and scale}
\usage{
permutation.scale(
  data,
  permutation = NA,
  covariance = FALSE,
  return.array = TRUE,
  num.layers = 1
)
}
\arguments{
\item{data}{The dataset}

\item{permutation}{Vector with the permutation of the data}

\item{covariance}{Logic variable indicating whether the analysis uses covariance or correlation matrix}

\item{return.array}{Return the data as 3-dimensional array}

\item{num.layers}{Number of timepoints}
}
\value{
The dataset that is permuted, either in matrix or array
}
\description{
It finds the vector of permutation to permute data by its largest absolute value in each eigenvector. It sets the order by specified number of factors, and the rest is ordered as they were. The data is permuted, and if needed, scaled.
}
