% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClustCpObj.R
\name{ClustCpObj}
\alias{ClustCpObj}
\title{ClustCpObj class constructor}
\usage{
ClustCpObj(
  data = NULL,
  n_iterations = NULL,
  n_burnin = NULL,
  clust = NULL,
  orders = NULL,
  time = NULL,
  norm_vec = NULL,
  entropy_MCMC = NULL,
  lkl_MCMC = NULL,
  I0_MCMC = NULL,
  kernel_ts = NULL,
  kernel_epi = NULL,
  univariate_ts = NULL
)
}
\arguments{
\item{data}{A vector or matrix containing the observed data.}

\item{n_iterations}{Total number of MCMC iterations.}

\item{n_burnin}{Number of burn-in iterations removed from posterior summaries.}

\item{clust}{A matrix where each row contains the cluster assignments for one iteration.}

\item{orders}{A multidimensional array where each slice is a matrix representing
the latent order at each iteration.}

\item{time}{Total computational time (in seconds).}

\item{norm_vec}{A vector containing precomputed normalization constants.}

\item{entropy_MCMC}{A \code{coda::mcmc} object containing the MCMC samples of the entropy.}

\item{lkl_MCMC}{A \code{coda::mcmc} object containing the log-likelihood values at each iteration.}

\item{I0_MCMC}{A \code{coda::mcmc} object with the MCMC trace of the initial infection proportion \eqn{I_0}.}

\item{kernel_ts}{Logical; TRUE if the kernel corresponds to time-series data.}

\item{kernel_epi}{Logical; TRUE if the kernel corresponds to epidemic diffusion data.}

\item{univariate_ts}{Logical; TRUE if the data represent a univariate time series,
FALSE for multivariate time series.}
}
\value{
An object of class \code{ClustCpObj}.
}
\description{
A constructor for the \code{ClustCpObj} class, which stores the output of
the change point detection and clustering algorithms.
}
