% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{compileModelAndMCMC}
\alias{compileModelAndMCMC}
\title{Compile a 'nimble' Model and Its MCMC}
\usage{
compileModelAndMCMC(object)
}
\arguments{
\item{object}{Class \code{BayesSIM_setup} object}
}
\value{
A list with two elements:
\describe{
\item{\code{model}}{the compiled NIMBLE model (external pointer object).}
\item{\code{mcmc}}{the compiled MCMC function/algorithm bound to the model.}
}
}
\description{
Compiles a nimble model object and a corresponding (uncompiled) MCMC
algorithm and returns the compiled pair.
}
\details{
The function first compiles \code{nimble} model object, then compiles \code{nimble} sampler.
Both compiled model and compiled MCMC samplers are returned as a list.
}
\examples{
\donttest{
simdata2 <- data.frame(DATA1$X, y = DATA1$y)

# 1. One tool version
fit_one <- BayesSIM(y ~ ., data = simdata2,
                    niter = 5000, nburnin = 1000, nchain = 1)


# 2. Split version
models <- BayesSIM_setup(y ~ ., data = simdata2)
Ccompile <- compileModelAndMCMC(models)
nimSampler <- get_sampler(Ccompile)
initList <- getInit(models)
mcmc.out <- runMCMC(nimSampler, niter = 5000, nburnin = 1000, thin = 1,
                    nchains = 1, setSeed = TRUE, inits = initList,
                    summary = TRUE, samplesAsCodaMCMC = TRUE)

# "fit_split" becomes exactly the same as the class of "fit_one" object and apply generic functions.
fit_split <- as_bsim(models, mcmc.out)

}

}
\seealso{
\code{\link[nimble]{nimbleModel}},
\code{\link[nimble]{configureMCMC}},
\code{\link[nimble]{buildMCMC}},
\code{\link[nimble]{compileNimble}},
\code{\link[nimble]{runMCMC}}
}
