% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{getInit}
\alias{getInit}
\title{Get Initial Value of the Model}
\usage{
getInit(object)
}
\arguments{
\item{object}{A fitted object of \code{BayesSIM}, \code{BayesSIM_setup} or individual model.}
}
\value{
BUGS code of the model definition.
}
\description{
Functions for getting list of initial values of the \pkg{nimble} model.
}
\details{
The list of initial values are returned. This can be helpful to use when you use \code{BayesSIM_setup}.
You should be aware of that if you want to get more than 1 chain of MCMC samples, you should change \code{nchain} argument in \code{BayesSIM_setup}.
The output of initial values would be different, depending on the number of chain.

You can apply \code{BayesSIM} object when you want to check the list of initial values.
}
\examples{
\donttest{
simdata2 <- data.frame(DATA1$X, y = DATA1$y)


# Split version
models <- BayesSIM_setup(y ~ ., data = simdata2)
Ccompile <- compileModelAndMCMC(models)
nimSampler <- get_sampler(Ccompile)
initList <- getInit(models)
mcmc.out <- runMCMC(nimSampler, niter = 5000, nburnin = 1000, thin = 1,
                    nchains = 1, setSeed = TRUE, inits = initList,
                    summary = TRUE, samplesAsCodaMCMC = TRUE)

# "fit_split" becomes exactly the same as the class of "fit_one" object and apply generic functions.
fit_split <- as_bsim(models, mcmc.out)

}


}
