% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.BchronologyRun.R
\name{summary.BchronologyRun}
\alias{summary.BchronologyRun}
\title{Summarise a Bchronology object}
\usage{
\method{summary}{BchronologyRun}(
  object,
  type = c("quantiles", "outliers", "convergence", "sed_rate", "acc_rate", "max_var"),
  probs = c(0.025, 0.25, 0.5, 0.75, 0.975),
  acc_probs = c(0.05, 0.95),
  useExisting = TRUE,
  numPos = 3,
  ...,
  digits = max(3, getOption("digits") - 3)
)
}
\arguments{
\item{object}{Output from a run of \code{\link{Bchronology}}}

\item{type}{Type of output required. The default (quantiles) gives the quantiles of the ages for each position in \code{predictPositions} from \code{\link{Bchronology}}. The other options provide outlier probabilities, convergence diagnostics, accumulation rates, sedimentation rate, and positions of maximum age variance}

\item{probs}{Probabilities (between 0 and 1) at which to summarise the predicted chronologies}

\item{acc_probs}{The age range over which to calculate accumulation rates (the default is between the 5\% and 95\% quantiles of all predicted ages)}

\item{useExisting}{Whether to use the predicted chronologies/positions to calculate the sedimentation rate (if TRUE - default) or to re-create them based on a unit-scaled position grid (if FALSE). The latter will be a little bit slower but will provide better sedimentation rate estimates if the original positions are not on a unit scale (e.g. each cm)}

\item{numPos}{The number of positions at which to provide the maximum variance}

\item{...}{Other arguments (not currently supported)}

\item{digits}{Number of digits to report values}
}
\value{
A data frame summarising the Bchronology object depending on the type of summary requested. For quantiles, a data frame with the quantiles for each position. For outliers, a data frame with outlier probabilities. For convergence, a data frame with p-values for convergence diagnostics. For sedimentation and accumulation rates, a data frame with the rates at each position/age. For maximum variance, a vector of positions with maximum age variance.
}
\description{
Summarise a \code{\link{Bchronology}} object
}
\seealso{
\code{\link{BchronCalibrate}}, \code{\link{Bchronology}} \code{\link{BchronRSL}}, \code{\link{BchronDensity}}, \code{\link{BchronDensityFast}}
}
