% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitBeeGUTS.R
\name{fitBeeGUTS}
\alias{fitBeeGUTS}
\title{Fit a GUTS model for bees survival analysis using Bayesian Inference (stan)}
\usage{
fitBeeGUTS(
  data,
  modelType = NULL,
  distribution = "loglogistic",
  priorsList = NULL,
  parallel = TRUE,
  nCores = parallel::detectCores() - 1L,
  nChains = 3,
  nIter = 2000,
  nWarmup = floor(nIter/2),
  thin = 1,
  adaptDelta = 0.95,
  odeIntegrator = "rk45",
  relTol = 1e-08,
  absTol = 1e-08,
  maxSteps = 1000,
  ...
)
}
\arguments{
\item{data}{An object of class \code{beeSurvData}}

\item{modelType}{A model type between \code{"SD"} for Stochastic Death and
\code{"IT"} for Individual Tolerance.}

\item{distribution}{A distribution for the IT death mechanism. To be chosen between
\code{"loglogistic"} and \code{"lognormal"}. Default is \code{"loglogistic"}}

\item{priorsList}{A list containing the prior distribution for the parameter considered.
By default, when no priors are provided (default is \code{NULL}), priors are set automatically
based on the experimental design (adapted from Delignette-Muller et al 2017)}

\item{parallel}{Logical indicating whether parallel computing should be used or not.  Default is \code{TRUE}}

\item{nCores}{A positive integer specifying the number of cores to use.
Default is one core less than maximum number of cores available}

\item{nChains}{A positive integer specifying the number of MCMC chains to run. Default is 3.}

\item{nIter}{A positive integer specifying the number of iteration to monitor for each MCMC chain. Default is 2000}

\item{nWarmup}{A positive integer specifying the number of warmup iteration per chain. Default is half the number of iteration}

\item{thin}{A positive integer specifying the interval between the iterations to monitor. Default is 1 (all iterations are monitored)}

\item{adaptDelta}{A double, bounded between 0 and 1 and controlling part of the sampling algorithms.
See the \code{control} in the function \code{stan} \code{\link[rstan:stan]{rstan::stan()}} of the package \code{rstan}. The default is 0.95.}

\item{odeIntegrator}{A string specifying the integrator used to solve the system of
differential equations (ODE) in the \code{stan} module. To be chosen between
\code{"rk45"} and \code{"euler"}. Default is \code{"rk45"}. The \code{"euler"}
integrator uses a fixed step of 0.01 d to calculate the solution (avoid using it
for fast varying concentrations)}

\item{relTol}{A double, bounded between 0 and 1 and controlling the relative tolerance
of the accuracy of the solutions generated by the integrator. A smaller tolerance produces
more accurate solution at the expanse of the computing time. Default is 1e-8}

\item{absTol}{A double, bounded between 0 and 1 and controlling the absolute tolerance
of the accuracy of the solutions generated by the integrator. A smaller tolerance produces
more accurate solution at the expanse of the computing time. Default is 1e-8}

\item{maxSteps}{A double controlling the maximum number of steps that can be
taken before stopping a runaway simulation. Default is 1000}

\item{...}{Additional parameters to be passed to \code{sampling} from \code{stan}}
}
\value{
The function \code{fitBeeGUTS} returns the parameter estimates
of the General Unified Threshold model of Survival (GUTS) in an object
of class \code{beeSurvFit}. This object is a list composed of the following:
\item{stanFit}{An object of S4 class \code{stanfit}. More information is available
in the package \code{rstan}. }
\item{data}{The data object provided as argument of the function}
\item{dataFit}{A list of data passed to the Stan model object}
\item{setupMCMC}{A list containing the setup used for the MCMC chains}
\item{modelType}{A character vector specifying the type of GUTS model used between
\code{SD} and \code{IT}}
\item{distribution}{A character vector specifying the type of distribution used in case \code{IT} was used;
\code{NA} otherwise}
\item{messages}{A character vector containing warning messages}
}
\description{
The function \code{fitBeeGUTS} estimates the parameters of a GUTS model
for the stochastic death (SD) or individual tolerance (IT) death mechanisms for
survival analysis using Bayesian inference.
}
\details{
The automated prior determination is modified from Delignette-Muller et al.
by considering that the minimal concentration for the prior can be close to 0 (1e-6)
whereas the original paper considered the lowest non-zero concentration.
Similarly, the minimal kd considered for the prior calculation was reduced to allow
more chance to capture slow kinetics.
}
\examples{
\donttest{
data(betacyfluthrinChronic)
fit <- fitBeeGUTS(betacyfluthrinChronic, modelType = "SD", nIter = 1000, nCores = 2)
}
}
\references{
Delignette-Muller, M.L., Ruiz P. and Veber P. (2017).
Robust fit of toxicokinetic-toxicodynamic models using prior knowledge contained in the design of survival toxicity tests.
\doi{10.1021/acs.est.6b05326}
}
