% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meansres.r
\name{auc}
\alias{auc}
\title{Calculate Area Under the Curve (AUC) for Pathway Scores}
\usage{
auc(celltype, pathway.scores, return.mean = TRUE, seed = 1)
}
\arguments{
\item{celltype}{A factor or character vector representing the cell type labels for each cell.}

\item{pathway.scores}{A matrix of pathway scores where rows represent cells and columns represent different pathways.}

\item{return.mean}{Logical, indicating whether to return the weighted mean AUC across all cell types. If \code{FALSE}, returns the AUC for each pathway. Default is \code{TRUE}.}

\item{seed}{An integer specifying the random seed for reproducibility. Default is 1.}
}
\value{
If \code{return.mean = TRUE}, a numeric vector containing the weighted mean AUC. If \code{return.mean = FALSE}, a numeric matrix of AUCs where rows represent pathways and columns represent cell types.
}
\description{
This function calculates the area under the curve (AUC) for pathway scores with respect to a specific cell type. It uses the AUC to evaluate the performance of the pathway scores in distinguishing the target cell type from others.
}
\examples{
# Example usage:
celltype <- factor(rep(letters[1:5], each = 20))
pathway.scores <- matrix(runif(1000), nrow = 100, ncol = 10)
colnames(pathway.scores) <- letters[1:10]
auc_values <- auc(celltype, pathway.scores, return.mean = TRUE)
print(auc_values)

}
\seealso{
\code{\link[DescTools]{AUC}} for the AUC calculation.
}
