% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runPipeline.R
\name{runPipeline}
\alias{runPipeline}
\title{runPipeline}
\usage{
runPipeline(
  segData,
  cores = 1,
  nsigs = 0,
  saveRes = FALSE,
  runName = "Run",
  rmin = 3,
  rmax = 12,
  components = NULL,
  max_comps = NULL,
  min_comps = NULL,
  fixedSigs = NULL,
  saveDir = NULL,
  smooth = FALSE,
  colMap = NULL,
  pR = FALSE,
  gbuild = "hg19",
  featsToUse = NULL,
  ploidyData = NULL,
  plot = TRUE
)
}
\arguments{
\item{segData}{The data to be analyzed. If a path name, readSegs is used to
make the list. Otherwise the list must be formatted correctly. Refer to 
?readSegs for format information.}

\item{cores}{The number of computer cores to be used for parallel processing}

\item{nsigs}{The number of signatures to look for. Value of 0 runs the 
determineSigNum function to look for optimal number. Default is 0.}

\item{saveRes}{Whether or not to save the resulting tables and plots. 
Default is FALSE}

\item{runName}{Used to title plots and files when saving results}

\item{rmin}{Minimum number of signatures to look for. Default is 3.}

\item{rmax}{Maximum number of signatures to look for. Default is 12.}

\item{components}{Can be used when fixing components. Default is NULL.}

\item{max_comps}{vector of length 6 specifying the max number of components 
for each feature. Passed to fitModels. Default is 10 for all features}

\item{min_comps}{vector of length 6 specifying the min number of components
for each feature. Passed to fitModels. Default is 2 for all features}

\item{fixedSigs}{Signature x Component matrix. Used when fixing signatures.
Default is NULL}

\item{saveDir}{Used to specify where to save the results, must be provided 
if using saveDir}

\item{smooth}{Whether or not to smooth the input data. Default is F.}

\item{colMap}{Mapping of column names when reading from text file. 
Default column names are ID, chromosome, start, end, segVal.}

\item{pR}{Peak Reduction}

\item{gbuild}{The reference genome build. Default is hg19. Also supports hg18 and hg38.}

\item{featsToUse}{Vector of feature names that you wish to use}

\item{ploidyData}{The ploidy data to use as a feature}

\item{plot}{Whether or not to generate the plots. Default is T.}
}
\value{
Returns a list with all of the results from the pipeline
}
\description{
This function allows you to run the entire Copy number signature pipeline
in one go. May take a while, especially if not given multiple cores. For 
more information on what actually happens in the pipeline, refer to the
CNSigs vignette.
}
\examples{
#Runs the entire pipeline on the example data giving it 6 cores and specifying
#5 signatures with a name of "TCGA Test"
\donttest{
runPipeline(segDataExp, cores = 6, nsigs = 5, saveRes = FALSE, "TCGA Test")}

}
\keyword{run}
