% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CustomCovariates.R
\name{createDuringCovariateSettings}
\alias{createDuringCovariateSettings}
\title{Create during covariate settings}
\usage{
createDuringCovariateSettings(
  useConditionOccurrenceDuring = FALSE,
  useConditionOccurrencePrimaryInpatientDuring = FALSE,
  useConditionEraDuring = FALSE,
  useConditionGroupEraDuring = FALSE,
  useDrugExposureDuring = FALSE,
  useDrugEraDuring = FALSE,
  useDrugGroupEraDuring = FALSE,
  useProcedureOccurrenceDuring = FALSE,
  useDeviceExposureDuring = FALSE,
  useMeasurementDuring = FALSE,
  useObservationDuring = FALSE,
  useVisitCountDuring = FALSE,
  useVisitConceptCountDuring = FALSE,
  includedCovariateConceptIds = c(),
  addDescendantsToInclude = FALSE,
  excludedCovariateConceptIds = c(),
  addDescendantsToExclude = FALSE,
  includedCovariateIds = c()
)
}
\arguments{
\item{useConditionOccurrenceDuring}{One covariate per condition in the
condition_occurrence table starting between
cohort start and cohort end. (analysis ID 109)}

\item{useConditionOccurrencePrimaryInpatientDuring}{One covariate per condition observed as
a primary diagnosis in an inpatient
setting in the condition_occurrence table starting between
cohort start and cohort end. (analysis ID 110)}

\item{useConditionEraDuring}{One covariate per condition in the condition_era table
starting between cohort start and cohort end.
(analysis ID 217)}

\item{useConditionGroupEraDuring}{One covariate per condition era rolled
up to groups in the condition_era table
starting between cohort start and cohort end.
(analysis ID 218)}

\item{useDrugExposureDuring}{One covariate per drug in the drug_exposure table between cohort start and end.
(analysisId 305)}

\item{useDrugEraDuring}{One covariate per drug in the drug_era table between cohort start and end.
(analysis ID 417)}

\item{useDrugGroupEraDuring}{One covariate per drug rolled up to ATC groups in the drug_era table between cohort start and end.
(analysis ID 418)}

\item{useProcedureOccurrenceDuring}{One covariate per procedure in the procedure_occurrence table between cohort start and end.
(analysis ID 505)}

\item{useDeviceExposureDuring}{One covariate per device in the device exposure table starting between cohort start and end.
(analysis ID 605)}

\item{useMeasurementDuring}{One covariate per measurement in the measurement table between cohort start and end.
(analysis ID 713)}

\item{useObservationDuring}{One covariate per observation in the observation table between cohort start and end.
(analysis ID 805)}

\item{useVisitCountDuring}{The number of visits observed between cohort start and end.
(analysis ID 926)}

\item{useVisitConceptCountDuring}{The number of visits observed between cohort start and end, stratified by visit concept ID.
(analysis ID 927)}

\item{includedCovariateConceptIds}{A list of concept IDs that should be
used to construct covariates.}

\item{addDescendantsToInclude}{Should descendant concept IDs be added
to the list of concepts to include?}

\item{excludedCovariateConceptIds}{A list of concept IDs that should NOT be
used to construct covariates.}

\item{addDescendantsToExclude}{Should descendant concept IDs be added
to the list of concepts to exclude?}

\item{includedCovariateIds}{A list of covariate IDs that should be
restricted to.}
}
\value{
An object of type \code{covariateSettings}, to be used in other functions.
}
\description{
Create during covariate settings
}
\details{
creates an object specifying how during covariates should be constructed from data in the CDM model.
}
\examples{
settings <- createDuringCovariateSettings(
  useConditionOccurrenceDuring = TRUE,
  useConditionOccurrencePrimaryInpatientDuring = FALSE,
  useConditionEraDuring = FALSE,
  useConditionGroupEraDuring = FALSE
)

}
\seealso{
Other CovariateSetting: 
\code{\link{getDbDuringCovariateData}()}
}
\concept{CovariateSetting}
