% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addConcepts.R
\name{addConcepts}
\alias{addConcepts}
\title{Add concepts to a codelist}
\usage{
addConcepts(x, cdm, concepts, codelistName = NULL)
}
\arguments{
\item{x}{A codelist.}

\item{cdm}{A cdm reference to an OMOP CDM dataset. If data is held within a
database, the vocabulary tables should be in the same schema as the clinical
tables (person, observation period, and so on).}

\item{concepts}{Concepts_ID to add}

\item{codelistName}{Name or names of codelist in x. If NULL, all codelist present
in x will be considered.}
}
\value{
A codelist
}
\description{
Add concepts to a codelist
}
\examples{
\donttest{
library(omock)
library(CDMConnector)

# Creating CDM object
cdm <- mockCdmFromDataset(datasetName = "GiBleed")

# Creating codelist
codelist <- getDrugIngredientCodes(cdm,
                                   nameStyle = "{concept_name}")

# Add a concept to all the codelists:
codelist$acetaminophen
codelist <- codelist |>
 addConcepts(cdm, concepts = c(1L))
codelist$acetaminophen

# Add a concept to a specific codelist
codelist$amiodarone
codelist <- codelist |>
  addConcepts(cdm, concepts = c(2L), codelistName = "amiodarone")
codelist$amiodarone

# See function: `excludeConcepts()` for details on how to remove specific concepts
# from a codelist
}
}
