% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asCodelist.R
\name{asCodelist}
\alias{asCodelist}
\alias{asCodelist.codelist}
\alias{asCodelist.codelist_with_details}
\alias{asCodelist.concept_set_expression}
\alias{asCodelist.candidate_codes}
\title{Coerce to a codelist}
\usage{
asCodelist(x, ...)

\method{asCodelist}{codelist}(x, ...)

\method{asCodelist}{codelist_with_details}(x, ...)

\method{asCodelist}{concept_set_expression}(x, cdm, ...)

\method{asCodelist}{candidate_codes}(x, ...)
}
\arguments{
\item{x}{Only codelist_with_details and candidate_codes are currently supported.}

\item{...}{For extensibility}

\item{cdm}{A cdm reference to an OMOP CDM dataset. If data is held within a
database, the vocabulary tables should be in the same schema as the clinical
tables (person, observation period, and so on).}
}
\value{
codelist
}
\description{
Coerce to a codelist
}
\examples{
\donttest{
library(omock)
library(CDMConnector)

# Creating CDM object
cdm <- mockCdmFromDataset(datasetName = "GiBleed")

# Create codelist from a codelist_with_details
codelist <- getDrugIngredientCodes(cdm,
                                   name = "acetaminophen",
                                   nameStyle = "{concept_name}",
                                   type = "codelist_with_details")

asCodelist(codelist)

# Create codelist from a candidate_codes
codelist <- getCandidateCodes(cdm,
                              keywords = "arthritis")

asCodelist(codelist)

}
}
