% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asConceptSetExpression.R
\name{asConceptSetExpression}
\alias{asConceptSetExpression}
\alias{asConceptSetExpression.codelist}
\alias{asConceptSetExpression.codelist_with_details}
\title{Coerce to a concept set expression}
\usage{
asConceptSetExpression(x, ...)

\method{asConceptSetExpression}{codelist}(x, ...)

\method{asConceptSetExpression}{codelist_with_details}(x, ...)
}
\arguments{
\item{x}{Codelist or codelist with details}

\item{...}{For extensibility}
}
\value{
codelist
}
\description{
Coerce to a concept set expression
}
\examples{
\donttest{
library(omock)
library(CDMConnector)

# Creating CDM object
cdm <- mockCdmFromDataset(datasetName = "GiBleed")

# Create concept_set_expression from a codelist
codelist <- getDrugIngredientCodes(cdm,
                                   name = "acetaminophen",
                                   nameStyle = "{concept_name}",
                                   type = "codelist")

asConceptSetExpression(codelist)

# Create concept_set_expression from a codelist_with_details
codelist <- getDrugIngredientCodes(cdm,
                                   name = "acetaminophen",
                                  nameStyle = "{concept_name}",
                                   type = "codelist_with_details")

asConceptSetExpression(codelist)
}
}
