% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableCharacteristics.R
\name{tableCharacteristics}
\alias{tableCharacteristics}
\title{Format a summarise_characteristics object into a visual table.}
\usage{
tableCharacteristics(
  result,
  type = NULL,
  header = c("cdm_name", "cohort_name"),
  groupColumn = character(),
  hide = c(additionalColumns(result), settingsColumns(result)),
  style = NULL,
  .options = list()
)
}
\arguments{
\item{result}{A summarised_result object.}

\item{type}{Character string specifying the desired output table format. See
\code{visOmopResults::tableType()} for supported table types. If type = \code{NULL},
global options (set via \code{visOmopResults::setGlobalTableOptions()}) will be
used if available; otherwise, a default 'gt' table is created.}

\item{header}{Columns to use as header. See options with
\code{availableTableColumns(result)}.}

\item{groupColumn}{Columns to group by. See options with
\code{availableTableColumns(result)}.}

\item{hide}{Columns to hide from the visualisation. See options with
\code{availableTableColumns(result)}.}

\item{style}{Defines the visual formatting of the table. This argument can
be provided in one of the following ways:
\enumerate{
\item \strong{Pre-defined style}: Use the name of a built-in style (e.g., "darwin").
See \code{visOmopResults::tableStyle()} for available options.
\item \strong{YAML file path}: Provide the path to an existing .yml file defining a
new style.
\item \strong{List of custome R code}: Supply a block of custom R code or a named
list describing styles for each table section. This code must be specific to
the selected table type.
}

If style = \code{NULL}, the function will use global
options (see \code{visOmopResults::setGlobalTableOptions()}) or an existing
\verb{_brand.yml} file (if found); otherwise, the default style is applied. For
more details, see the \emph{Styles} vignette in \strong{visOmopResults} website.}

\item{.options}{A named list with additional formatting options.
\code{visOmopResults::tableOptions()} shows allowed arguments and their default
values.}
}
\value{
A formatted table.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
\donttest{
library(CohortCharacteristics)

cdm <- mockCohortCharacteristics()

result <- summariseCharacteristics(cdm$cohort1)

tableCharacteristics(result)

}

}
