% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intersectCohorts.R
\name{intersectCohorts}
\alias{intersectCohorts}
\title{Generate a combination cohort set between the intersection of different
cohorts.}
\usage{
intersectCohorts(
  cohort,
  cohortId = NULL,
  gap = 0,
  returnNonOverlappingCohorts = FALSE,
  keepOriginalCohorts = FALSE,
  name = tableName(cohort),
  .softValidation = FALSE
)
}
\arguments{
\item{cohort}{A cohort table in a cdm reference.}

\item{cohortId}{Vector identifying which cohorts to include
(cohort_definition_id or cohort_name). Cohorts not included will be
removed from the cohort set.}

\item{gap}{Number of days between two subsequent cohort entries to be merged
in a single cohort record.}

\item{returnNonOverlappingCohorts}{Whether the generated cohorts are mutually
exclusive or not.}

\item{keepOriginalCohorts}{If TRUE the original cohorts will be return
together with the new ones. If FALSE only the new cohort will be returned.}

\item{name}{Name of the new cohort table created in the cdm object.}

\item{.softValidation}{Whether to perform a soft validation of consistency.
If set to FALSE four additional checks will be performed: 1) a check that
cohort end date is not before cohort start date,  2) a check that there
are no missing values in required columns, 3) a check that cohort duration is
all within observation period, and 4) that there are no overlapping
cohort entries}
}
\value{
A cohort table.
}
\description{
\code{intersectCohorts()} combines different cohort entries, with those records
that overlap combined and kept. Cohort entries are when an individual was in
\emph{both} of the cohorts.
}
\examples{
\donttest{
library(CohortConstructor)
cdm <- mockCohortConstructor()

cdm$cohort3 <- intersectCohorts(cohort = cdm$cohort2, name = "cohort3")

settings(cdm$cohort3)
}
}
