% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DPPC.R
\name{DPPC}
\alias{DPPC}
\title{Distributed projection principal component}
\usage{
DPPC(data, m, n1, K)
}
\arguments{
\item{data}{is a total data set}

\item{m}{is the number of principal component}

\item{n1}{is  the length of each data subset}

\item{K}{is the number of nodes}
}
\value{
Apro,pro,Sigmahathatpro
}
\description{
Distributed projection principal component
}
\examples{
library(LaplacesDemon)
library(MASS)
n=1000
p=10
m=5
mu=t(matrix(rep(runif(p,0,1000),n),p,n))
mu0=as.matrix(runif(m,0))
sigma0=diag(runif(m,1))
F=matrix(mvrnorm(n,mu0,sigma0),nrow=n)
A=matrix(runif(p*m,-1,1),nrow=p)
lanor <- rlaplace(n*p,0,1)
epsilon=matrix(lanor,nrow=n)
D=diag(t(epsilon)\%*\%epsilon)
data=mu+F\%*\%t(A)+epsilon
DPPC(data,m=3,n1=128,K=2)
}
