% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_data_package_identifiers.R
\name{list_data_package_identifiers}
\alias{list_data_package_identifiers}
\title{List data package identifiers}
\usage{
list_data_package_identifiers(scope, env = "production")
}
\arguments{
\item{scope}{(character) Scope of data package}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(numeric) Identifiers of data packages within a specified
\code{scope}
}
\description{
List data package identifiers
}
\examples{
\dontrun{

# List identifiers
identifiers <- list_data_package_identifiers("knb-lter-ble")
identifiers
#> [1]  1  2  3  4  5  6  7  8  9 10 11 12 13 14 15 16 17 18 19 23
}
}
\seealso{
Other Listing: 
\code{\link{list_data_descendants}()},
\code{\link{list_data_entities}()},
\code{\link{list_data_package_revisions}()},
\code{\link{list_data_package_scopes}()},
\code{\link{list_data_sources}()},
\code{\link{list_deleted_data_packages}()},
\code{\link{list_recent_changes}()},
\code{\link{list_recent_uploads}()},
\code{\link{list_service_methods}()},
\code{\link{list_user_data_packages}()}
}
\concept{Listing}
