% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chisquare.evalueate.core.R
\name{chisquare.evaluate.core}
\alias{chisquare.evaluate.core}
\title{Chi-squared Test for Homogeneity}
\usage{
chisquare.evaluate.core(data, names, qualitative, selected, na.omit = TRUE)
}
\arguments{
\item{data}{The data as a data frame object. The data frame should possess
one row per individual and columns with the individual names and multiple
trait/character data.}

\item{names}{Name of column with the individual names as a character string.}

\item{qualitative}{Name of columns with the qualitative traits as a character
vector.}

\item{selected}{Character vector with the names of individuals selected in
core collection and present in the \code{names} column.}

\item{na.omit}{logical. If \code{TRUE}, missing values (\code{NA}) are
ignored and not included as a distinct factor level for analysis. Default
is \code{TRUE}.}
}
\value{
A a data frame with the following columns. \item{Trait}{The
  qualitative trait.} \item{EC_No.Classes}{The number of classes in the trait
  for EC.} \item{EC_Classes}{The frequency of the classes in the trait for
  EC.} \item{CS_No.Classes}{The number of classes in the trait for CS.}
  \item{CS_Classes}{The frequency of the classes in the trait for CS.}
  \item{chisq_statistic}{The \mjseqn{\chi^{2}} test statistic.}
  \item{chisq_pvalue}{The p value for the test statistic.}
  \item{chisq_significance}{The significance of the test statistic (*: p
  \mjseqn{\leq} 0.01; **: p \mjseqn{\leq} 0.05; ns: p \mjseqn{ > } 0.05).}
}
\description{
Compare the distribution frequencies of qualitative traits between entire
collection (EC) and core set (CS) by Chi-squared test for homogeneity
\insertCite{pearson_x._1900,snedecor_chi-square_1933}{EvaluateCore}.
\loadmathjax
}
\examples{

data("cassava_CC")
data("cassava_EC")

ec <- cbind(genotypes = rownames(cassava_EC), cassava_EC)
ec$genotypes <- as.character(ec$genotypes)
rownames(ec) <- NULL

core <- rownames(cassava_CC)

quant <- c("NMSR", "TTRN", "TFWSR", "TTRW", "TFWSS", "TTSW", "TTPW", "AVPW",
           "ARSR", "SRDM")
qual <- c("CUAL", "LNGS", "PTLC", "DSTA", "LFRT", "LBTEF", "CBTR", "NMLB",
          "ANGB", "CUAL9M", "LVC9M", "TNPR9M", "PL9M", "STRP", "STRC",
          "PSTR")

ec[, qual] <- lapply(ec[, qual],
                     function(x) factor(as.factor(x)))

chisquare.evaluate.core(data = ec, names = "genotypes",
                        qualitative = qual, selected = core)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[stats]{chisq.test}}
}
