% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_doc.R
\docType{data}
\name{equations_GCubeR}
\alias{equations_GCubeR}
\title{Equations metadata for GCubeR}
\format{
A data frame with columns:
\describe{
\item{eq_id}{Equation identifier (character)}
\item{method}{Method family (Vallet, Dagnelie, Algan, Rondeux, CNPF...)}
\item{predicted_variable}{Predicted variable (volume, biomass, carbon...)}
\item{output_unit}{Unit of the output (m3, kg, tdm...)}
\item{species_id}{Numeric species identifier (integer)}
\item{species_name_fr}{Species name in French (character)}
\item{species_code}{Species code (uppercase Latin name)}
\item{validity_region}{Region of validity (text)}
\item{validity_range}{Range of validity (text)}
\item{input_variable}{Input variables required (e.g. c130, htot, dbh)}
\item{input_unit}{Units of input variables (e.g. cm, m)}
\item{formula_type}{Equation type (e.g. polynomial, exponential)}
\item{explicit_formula}{Explicit formula as text}
\item{coeff_a}{Equation coefficient a (numeric)}
\item{coeff_b}{Equation coefficient b (numeric)}
\item{coeff_c}{Equation coefficient c (numeric)}
\item{coeff_d}{Equation coefficient d (numeric)}
\item{coeff_e}{Equation coefficient e (numeric)}
\item{coeff_f}{Equation coefficient f (numeric)}
\item{remarks}{Additional notes}
\item{reference_source}{Bibliographic source}
}
}
\source{
Internal CSV file \code{data-raw/equations_GCubeR.csv}
}
\usage{
data(equations_GCubeR)
}
\description{
A reference table compiling metadata about allometric equations used in GCubeR
(Vallet, Dagnelie, Algan, Rondeux, CNPF, etc.). This dataset is provided
for information purposes only and is not directly used by package functions.
}
\keyword{datasets}
