% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/gemIntertemporal_EndogenousEquilibriumInterestRate__ForeignExchangeRate.R
\name{gemIntertemporal_EndogenousEquilibriumInterestRate_ForeignExchangeRate}
\alias{gemIntertemporal_EndogenousEquilibriumInterestRate_ForeignExchangeRate}
\title{Some Examples Illustrating Endogenous Equilibrium Interest Rates and Foreign Exchange Rates in an Intertemporal Pure Exchange Economy with Two Currencies}
\usage{
gemIntertemporal_EndogenousEquilibriumInterestRate_ForeignExchangeRate(...)
}
\arguments{
\item{...}{arguments to be passed to the function sdm2.}
}
\description{
These examples illustrate (endogenous) equilibrium primitive interest rates and foreign exchange rates in an intertemporal pure exchange economy with two currencies.
Assume that the velocity of money is equal to one, that is, money circulates once per period.
}
\examples{
\donttest{
f <- function(ir, es = 1, beta, beta_prime = beta, return.ge = FALSE) {
  np <- length(beta) / 2
  n <- 4 * np # the number of commodity kinds
  m <- 2 # the number of agent kinds

  ir[c(np, 2 * np)] <- last.ir <- 1000
  dst.consumer1 <- node_new(
    "util",
    type = "SCES", alpha = 1, es = es,
    beta = beta,
    paste0("cc", 1:(2 * np))
  )
  for (k in 1:(2 * np)) {
    node_set(
      dst.consumer1,
      paste0("cc", k),
      type = "FIN", rate = ir[k],
      paste0("lab", k), paste0("money", k)
    )
  }

  dst.consumer2 <- Clone(dst.consumer1)
  dst.consumer2$beta <- beta_prime

  names.commodity <- c(
    paste0("lab", 1:(2 * np)),
    paste0("money", 1:(2 * np))
  )
  names.agent <- paste0("consumer", 1:m)

  ## the exogenous supply matrix.
  S0Exg <- matrix(NA, n, m, dimnames = list(names.commodity, names.agent))
  S0Exg[paste0("lab", 1:np), "consumer1"] <-
    S0Exg[paste0("lab", (np + 1):(2 * np)), "consumer2"] <- 100
  S0Exg[paste0("money", 1:np), "consumer1"] <-
    S0Exg[paste0("money", (np + 1):(2 * np)), "consumer2"] <- 1

  # the output coefficient matrix.
  B <- matrix(0, n, m, dimnames = list(names.commodity, names.agent))

  ge <- sdm2(
    A = list(dst.consumer1, dst.consumer2),
    B = B,
    S0Exg = S0Exg,
    names.commodity = names.commodity,
    names.agent = names.agent,
    numeraire = "lab1",
    ts = TRUE
  )

  tmp <- rowSums(ge$SV)
  ts.trading.value <- tmp[paste0("lab", 1:(2 * np))] * (1 + ir)

  ir[1:(np - 1)] <- ts.trading.value[1:(np - 1)] / ts.trading.value[2:np] - 1
  ir[(np + 1):(2 * np - 1)] <- ts.trading.value[(np + 1):(2 * np - 1)] /
    ts.trading.value[(np + 2):(2 * np)] - 1
  ir <- pmax(1e-6, ir)

  cat("ir: ", ir, "\n")
  cat("foreign.exchange.rate: ", ts.trading.value[(np + 1):(2 * np)] / ts.trading.value[1:np], "\n")
  if (return.ge) {
    ge$ts.trading.value <- ts.trading.value
    return(ge)
  } else {
    return(ir)
  }
}


##
np <- 4 # the number of economic periods
beta <- proportions(c(0.4, 0.3, 0.2, 0.1, 0.5, 0.25, 0.15, 0.1))
mat.ir <- iterate(rep(0.1, 2 * np), f, tol = 1e-4, beta = beta)
beta[1:(np - 1)] / beta[2:np] - 1 # domestic interest rates
beta[(np + 1):(2 * np - 1)] / beta[(np + 2):(2 * np)] - 1 # foreign interest rates
beta[(np + 1):(2 * np)] / beta[1:np] # foreign exchange rates

ge <- f(ir = tail(mat.ir, 1), es = 1.1, beta = beta, return.ge = TRUE)

## Assume that the two consumers have different preferences.
random.beta <- function(np) {
  beta <- runif(np, 0.9, 1) |>
  cumprod() |>
  proportions()
}

set.seed(1)
np <- 5
beta <- proportions(c(random.beta(np), random.beta(np)))
beta_prime <- proportions(c(random.beta(np), random.beta(np)))
mat.ir <- iterate(rep(0.1, 2 * np), f, tol = 1e-4, beta = beta, beta_prime = beta_prime)

# Calculate the equilibrium exchange rates and
# interest rates based on closed-form solutions.
compute_fx_ir <- function(beta, beta_prime) {
  np <- length(beta) / 2
  xi1 <- sum(beta_prime[1:np])
  xi2 <- sum(beta[(np + 1):(2 * np)])

  v_tilde <- xi2 * beta_prime + xi1 * beta
  names(v_tilde) <- paste0("v", seq_len(2 * np))

  foreign.exchange.rate <- v_tilde[(np + 1):(2 * np)] / v_tilde[1:np]
  names(foreign.exchange.rate) <- paste0("epsilon", 1:np)

  r <- rep(NA_real_, 2 * np)
  for (i in 1:(2 * np - 1)) r[i] <- v_tilde[i] / v_tilde[i + 1] - 1
  r[np] <- Inf
  r[2 * np] <- Inf
  names(r) <- paste0("r", 1:(2 * np))

  list(
    ir = r,
    foreign.exchange.rate = foreign.exchange.rate
  )
}

compute_fx_ir(beta, beta_prime)
}
}
\seealso{
\code{\link{gemIntertemporal_EndogenousEquilibriumInterestRate}}
}
