% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_seasonality.R
\name{plot_seasonality}
\alias{plot_seasonality}
\title{Seasonality plot}
\usage{
plot_seasonality(
  data,
  var,
  time,
  type = "cov",
  pop = NULL,
  pt = 1e+05,
  area = NULL,
  aggregate_space = NULL,
  aggregate_time = "month",
  aggregate_space_fun = "mean",
  aggregate_time_fun = "mean",
  transform = "identity",
  title = NULL,
  var_label = NULL,
  ylab = NULL,
  xlab = NULL,
  free_y_scale = FALSE,
  palette = "IDE1"
)
}
\arguments{
\item{data}{Data frame containing equally spaced (daily, weekly, monthly)
covariate or disease case observations for one or multiple locations.}

\item{var}{Name of the column identifying the variable to be plotted.}

\item{time}{Name of the variable that identifies the temporal dimension
of the data frame. Its values must be in date format ("yyyy-mm-dd")
representing the day of observation for daily data, the first day of the
week for weekly, or the first day of the month for monthly observations.}

\item{type}{Character that specifies the type of variable in \code{var}.
Possible values include 'cov' (covariate, default), 'counts' (case counts),
and 'inc' (case incidence). If \code{type='inc'}, \code{pop} is required.}

\item{pop}{Character identifying the variable name for population. Only
needed if \code{type='inc'}.}

\item{pt}{Scale of the person-time (default 100,000) for incidence rates.}

\item{area}{Name of variable that identifies the different locations
(e.g., areal units) for which a time series is available.}

\item{aggregate_space}{Name of variable used to define spatial aggregation
groups.}

\item{aggregate_time}{Temporal scale used to perform
temporal aggregation. Options are: "week" (ISO 8601), "month", "year".}

\item{aggregate_space_fun}{Character indicating the function to be used
in the aggregation over space for \code{type="cov"}. Options are "mean" (default),
"median", "sum". For case counts and incidence, "sum" is always applied.}

\item{aggregate_time_fun}{Character indicating the function to be used
in the aggregation over time for \code{type="cov"}. Options are "mean" (default),
"median", "sum". For case counts and incidence, "sum" is always applied.}

\item{transform}{Character, defaults to "identity" (i.e., no transformation).
Transforms the y-axis for better visualization. Useful options include
"log10p1" \code{log10(x+1)} for case counts and incidence with 0s, or
any of the in-built ggplot2 options such as  "log10" \code{log10(x)}, "log1p"
\code{log(x+1)}, and "sqrt" \code{sqrt(x)} (check all possible options using
\code{?scale_y_continuous}).}

\item{title}{Optional title of the plot.}

\item{var_label}{Character with a custom name for the case or covariate
variable.}

\item{ylab}{Label for the y-axis.}

\item{xlab}{Label for the x-axis.}

\item{free_y_scale}{If TRUE, the y-axis scale is free in each facet.}

\item{palette}{GHR, RColorBrewer or colorspace palette. Use "-" before the
palette name (e.g., "-Reds") to reverse it.}
}
\value{
A ggplot2 seasonality plot.
}
\description{
Plots yearly time series of covariates, case counts, or
incidence rates to explore seasonality patterns.
}
\examples{
# Load data
data("dengue_MS")

# Seasonality plot of a covariate with space aggregation
plot_seasonality(dengue_MS,
                 var = "tmax",
                 time = "date",
                 var_label = "Max temp.",
                 type = "cov",
                 area = "micro_code",
                 aggregate_space = "region_code")

# Plot case counts (log scale) with space aggregation
 plot_seasonality(dengue_MS,
                  var = "dengue_cases",
                  time = "date",
                  type = "counts",
                  area = "micro_code",
                  aggregate_space = "meso_code",
                  transform = "log10p1",
                  var_label = "Monthly Dengue Cases",
                  xlab = "Month",
                  ylab = "Number of cases",
                  free_y_scale = TRUE)

# Seasonality plot of incidence
plot_seasonality(dengue_MS,
                 var = "dengue_cases",
                 time = "date",
                 type = "inc",
                 pop = "population",
                 area = "micro_code",
                 pt = 1000,
                 title = "Monthly Dengue Incidence",
                 palette = "Reds")

}
