% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_instances.R
\name{create_instance}
\alias{create_instance}
\title{Create a tumor phylogenetic tree instance}
\usage{
create_instance(
  n,
  m,
  k,
  selection,
  noisy = TRUE,
  depth = 30,
  seed = Sys.time()
)
}
\arguments{
\item{n}{An integer representing the number of clones.}

\item{m}{An integer representing the number of samples.}

\item{k}{A numeric value that determines the linearity of the tree topology. Also referred to as the topology parameter. Increasing values of this parameter increase the linearity of the topology. When `k` is set to 1, all nodes have equal probabilities of being chosen as parents, resulting in a completely random topology.}

\item{selection}{A character string representing the evolutionary mode the tumor follows. This should be either "positive" or "neutral".}

\item{noisy}{A logical value indicating whether to add noise to the frequency matrix. If `TRUE`, noise is added to the frequency matrix. If `FALSE`, no noise is added. `TRUE` by default.}

\item{depth}{A numeric value representing the mean depth of sequencing. 30 by default.}

\item{seed}{A numeric value used to set the seed for the random number generator. Sys.time() by default.}
}
\value{
A list containing four elements: 'F', a matrix representing the noisy frequencies of each mutation in each sample; 'B', a matrix representing the mutation relationships between the clones in the tumor; 'U', a matrix that represents the frequencies of the clones in the tumor in the set of samples; and 'F_true', a matrix representing the true frequencies of each mutation in each sample.
}
\description{
This function generates a tumor phylogenetic tree instance, composed by a mutation matrix (B matrix), a matrix of true variant allele frequencies (F_true), a matrix of noisy variant allele frequencies (F), and a matrix of clone frequencies in samples (U).
}
\details{
The B matrix is a square matrix representing the mutation relationships between the clones in the tumor, or, in other words, it represents the topology of the phylogenetic tree. The F_true matrix represents the true variant allele frequencies of the mutations present in the tumor in a set of samples. The F matrix represents the noisy variant allele frequencies of the mutations in the same set of samples. The U matrix represents the frequencies of the clones in the tumor in the set of samples.
}
\examples{
# Create an instance of a tumor with 10 clones,
# 4 samples, k = 1, neutral evolution and
# added noise with depth = 500
I1 <- create_instance(
  n = 10,
  m = 4,
  k = 1,
  selection = "neutral",
  depth = 500)
  

# Create an instance of a tumor with 50 clones,
# 10 samples, k = 5, positive selection and
# added noise with depth = 500
I2 <- create_instance(
  n = 50,
  m = 10,
  k = 5,
  selection = "positive", 
  noisy = TRUE,
  depth = 500)
  
  
# Create an instance of a tumor with 100 clones,
# 25 samples, k = 0, positive selection without 
# noise
I3 <- create_instance(
  n = 100,
  m = 25,
  k = 0,
  selection = "positive", 
  noisy = FALSE)
}
