% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_clustered_mar.R
\name{generate_clustered_mar}
\alias{generate_clustered_mar}
\title{Simulate clustered continuous outcomes with covariate-dependent MAR missingness}
\usage{
generate_clustered_mar(
  n,
  m = 4L,
  d = 2L,
  beta = NULL,
  sigma_b = 0.7,
  sigma_eps = 1,
  rho = 0,
  hetero_gamma = 0,
  x_dist = c("normal", "bernoulli", "uniform"),
  x_params = NULL,
  alpha0 = -0.2,
  alpha = NULL,
  target_missing = NULL,
  seed = NULL
)
}
\arguments{
\item{n}{Number of clusters (subjects).}

\item{m}{Cluster size. Either a single positive integer (common \eqn{m_i=m}) or
an integer vector of length \code{n} specifying \eqn{m_i} for each subject.}

\item{d}{Covariate dimension.}

\item{beta}{Population regression coefficients for \eqn{Y\mid X} (length \code{d}).
If \code{NULL}, defaults to \code{seq(0.5, 0.5 + 0.1*(d-1), by=0.1)}.}

\item{sigma_b}{SD of subject random intercept \eqn{b_i}.}

\item{sigma_eps}{Marginal SD of within-subject errors \eqn{\varepsilon_{i,j}}.}

\item{rho}{AR(1) correlation parameter within cluster for \eqn{\varepsilon_{i,j}}.}

\item{hetero_gamma}{Optional heteroskedasticity parameter; a value of 0 yields the
standard homoskedastic model, while nonzero values induce covariate-dependent
error variance through the first covariate \eqn{X_1}.}

\item{x_dist}{Distribution for covariates: \code{"normal"}, \code{"bernoulli"}, or \code{"uniform"}.}

\item{x_params}{Optional list of distribution parameters for \code{x_dist}.}

\item{alpha0}{Missingness intercept \eqn{\alpha_0}. If \code{target_missing} is not \code{NULL},
the effective intercept becomes \eqn{\alpha_0 + s}, where \eqn{s} is a calibrated shift.}

\item{alpha}{Missingness slopes (length \code{d}). If \code{NULL}, defaults to zeros.}

\item{target_missing}{Target \emph{marginal missing proportion} defined as the empirical
average of the fitted missing probabilities \eqn{1-\pi(X_{i,j})} over all observations,
where \eqn{\pi(x)=\Pr(\delta=1\mid X=x)}.
If \code{NULL}, no calibration.}

\item{seed}{Optional RNG seed.}
}
\value{
A \code{data.frame} in long format with one row per measurement:
\describe{
\item{id}{Cluster index.}
\item{j}{Within-cluster index.}
\item{Y}{Observed outcome; \code{NA} if missing.}
\item{Y_full}{Latent complete outcome.}
\item{delta}{Observation indicator (1 observed, 0 missing).}
\item{X1..Xd}{Covariates.}
}
Attributes:
\describe{
\item{\code{m_i}}{Integer vector of cluster sizes \eqn{(m_1,\ldots,m_n)}.}
\item{\code{target_missing}}{Target marginal missing proportion used for calibration,
defined as the empirical average of missing probabilities over all observations.}
\item{\code{alpha_shift}}{Calibrated global intercept shift \eqn{s} added to the missingness linear predictor
\eqn{\alpha_0 + s + \alpha^\top X_{i,j}} (present only when \code{target_missing} is provided).}
\item{\code{missing_rate}}{Sample missing rate \eqn{N^{-1}\sum I(\delta_{i,j}=0)}.
This may deviate from \code{target_missing} due to Bernoulli sampling variability.}
}
}
\description{
Simulates clustered data \eqn{\{(X_{i,j},Y_{i,j},\delta_{i,j})\}} under a hierarchical
subject-level model with covariate-dependent Missing at Random (MAR) missingness:
\eqn{\delta \perp Y \mid X}. Covariates \eqn{X_{i,j}} are fully observed, while outcomes
\eqn{Y_{i,j}} may be missing.

Data are generated according to the following mechanisms:
\itemize{
\item \strong{Between-subject level}: subject random intercepts \eqn{b_i\sim N(0,\sigma_b^2)}
induce within-cluster dependence, corresponding to latent subject-specific laws \eqn{P_i}.

\item \strong{Outcomes}: for each measurement \eqn{j=1,\ldots,m_i},
\deqn{
  Y_{i,j} = X_{i,j}^\top \beta + b_i + \varepsilon_{i,j},
  }
where, for each subject i, the within-cluster errors
\eqn{\{\varepsilon_{i,j}\}_{j=1}^{m_i}} are mutually independent with
\eqn{\varepsilon_{i,j}\sim N(0,\sigma_\varepsilon^2)} when \code{rho = 0}.
When \code{rho != 0}, they follow a stationary first-order autoregressive process
(AR(1)) within the cluster:
\deqn{
  \varepsilon_{i,j} = \rho\,\varepsilon_{i,j-1} + \eta_{i,j}, \quad
  \eta_{i,j}\sim N\!\left(0,\sigma_\varepsilon^2(1-\rho^2)\right),
  }
which implies \eqn{\mathrm{Var}(\varepsilon_{i,j})=\sigma_\varepsilon^2} and
\eqn{\mathrm{Cov}(\varepsilon_{i,j},\varepsilon_{i,j+k})
  = \sigma_\varepsilon^2\rho^{|k|}} for all k.

\item \strong{MAR missingness}: outcomes are observed with probability
\deqn{
  \Pr(\delta_{i,j}=1\mid X_{i,j}) = \mathrm{logit}^{-1}(\alpha_0+\alpha^\top X_{i,j}),
  }
which depends only on covariates, ensuring \eqn{\delta \perp Y \mid X}.
If \code{target_missing} is provided, the intercept \eqn{\alpha_0} is automatically
calibrated (via a deterministic root-finding procedure on the expected missing proportion)
so that the \emph{marginal missing proportion} is close to \code{target_missing}.
}
}
\examples{
dat <- generate_clustered_mar(
  n = 200, m = 5, d = 2,
  alpha0 = -0.2, alpha = c(-1.0, 0.0),
  target_missing = 0.30,
  seed = 1
)
mean(dat$delta == 0)      # ~0.30
attr(dat, "alpha_shift")  # calibrated shift

}
