% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotExAnteRawSeries.R
\name{plotExAnteRawSeries}
\alias{plotExAnteRawSeries}
\title{Ex-ante raw series forecasting}
\usage{
plotExAnteRawSeries(
  ex_ante_results,
  original_dataset,
  transformed_dataset = NULL,
  time_column,
  mae_metric = "median"
)
}
\arguments{
\item{ex_ante_results}{List. Output from `msm()` function with `forecast_type = "ex-ante"`}

\item{original_dataset}{Dataframe. The dataset imported with all features in its original scale of measures 
without normalization or log difference}

\item{transformed_dataset}{Dataframe. The dataset that is transformed for analysis including scaling and log difference}

\item{time_column}{Character. Name of the time column in the dataset.}

\item{mae_metric}{Character. Metric to highlight in plots ("mean", "median", or "mode"). Default is "median".}
}
\value{
A list containing:
\item{reverted_forecasts}{List of data frames, one per variable, with columns: time, mean, median, mode (reverted values)}
\item{plots}{List of plotly objects, one per variable, showing historical data and reverted forecasts}
}
\description{
Transforms ex-ante forecasts generated on a log-difference-12 scale back to the original raw data scale
}
\examples{
\dontrun{
# After running msm() for ex-ante forecasting
# Note: trainHVT_results and scoreHVT_results are needed for msm(), 
# but NOT for plotExAnteRawSeries() which uses the forecast values directly
ex_ante <- msm(state_time_data = temporal_data,
               forecast_type = "ex-ante",
               transition_probability_matrix = prob_trans_matx,
               initial_state = tail(temporal_data$Cell.ID, 1),
               n_ahead_ante = ex_ante_period,
               num_simulations = 500,
               scoreHVT_results = scoring,
               trainHVT_results = hvt.results,
               raw_dataset = entire_dataset,
               time_column = "t")

# Revert to raw scale - only needs ex_ante_results and original_dataset
raw_forecasts <- plotExAnteRawSeries(
  ex_ante_results = ex_ante,
  original_dataset = entire_dataset_original,  # Pre-transformation raw data
  transformed_dataset = entire_dataset,        # Post-transformation data 
  time_column = "t",
  mae_metric = "median"
)

# Access reverted forecasts
raw_forecasts$reverted_forecasts$CPI_Food

# Access plots
raw_forecasts$plots$CPI_Food
}
}
\author{
Vishwavani <vishwavani@mu-sigma.com>
}
\keyword{Timeseries_Analysis}
