% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_state_comparison_dataset.R
\name{create_state_comparison_dataset}
\alias{create_state_comparison_dataset}
\title{Creates comparison uptake dataset}
\usage{
create_state_comparison_dataset(
  dat,
  protein = unique(dat[["Protein"]])[1],
  states = unique(dat[["State"]]),
  time_0 = min(dat[["Exposure"]]),
  time_t = unique(dat[["Exposure"]])[3],
  time_100 = max(dat[["Exposure"]]),
  deut_part = 0.9
)
}
\arguments{
\item{dat}{data imported by the \code{\link{read_hdx}} function.}

\item{protein}{chosen protein.}

\item{states}{vector of states (for chosen protein), for which the 
calculations are done.}

\item{time_0}{minimal exchange control time point of measurement [min].}

\item{time_t}{time point of the measurement for which the calculations
are done [min].}

\item{time_100}{maximal exchange control time point of measurement [min].}

\item{deut_part}{deuterium percentage in solution used in experiment, 
value from range [0, 1].}
}
\value{
a \code{\link{data.frame}} object.
}
\description{
Calculates deuterium uptake values for selected 
biological states in selected time point of measurements.
}
\details{
Function \code{\link{create_state_comparison_dataset}} is a 
wrapper for \code{\link{calculate_state_uptake}} function, calls 
this function for all (default) or chosen states in states vector.
}
\examples{
comparison_dat <- create_state_comparison_dataset(alpha_dat)
head(comparison_dat)

}
\seealso{
\code{\link{read_hdx}}
\code{\link{calculate_state_uptake}}
}
