% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a.frame.logreg2.R
\name{frame.logreg2}
\alias{frame.logreg2}
\title{Evaluate Predicted Values for Logic Regression Trees}
\usage{
frame.logreg2(fit, msz, ntr, newbin, newresp, newsep, newcens, newweight)
}
\arguments{
\item{fit}{An object of class \code{"logreg"} fit to the training data}

\item{msz}{Maximum number of leaves on a tree (optional)}

\item{ntr}{Number of trees in the fit (optional)}

\item{newbin}{Binary matrix of predictors for new/out-of-sample data}

\item{newresp}{Vector of response values for new data}

\item{newsep}{Matrix of separate predictors for new data}

\item{newcens}{Vector of censoring indicators for new data (for survival models)}

\item{newweight}{Optional vector of observation weights}
}
\value{
A \code{data.frame} containing the response, weights, censoring indicators (if applicable), separate predictors, and evaluated predicted values for each tree.
}
\description{
INTERNAL FUNCTION TO EVALUATE IMPORTANCE OF PREDICTOR COMBINATIONS.
Prepares a data frame with responses, weights, censoring indicators, and evaluated predicted values for each tree in a fitted logic regression model.
Called by \code{predict.logreg2}, not intended to be used independently.
}
\details{
This function constructs a data frame for evaluating predicted values from logic regression trees.
It supports in-bag and out-of-sample data, handles optional censoring indicators, separate predictors, and observation weights.
The resulting data frame contains columns for:
\itemize{
\item Response variable
\item Observation weights
\item Censoring indicators (for survival models)
\item Separate predictors (if applicable)
\item Predicted values from each tree in the model
}
}
\keyword{internal}
