% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ar.r
\name{compute_AR_CI_optimized}
\alias{compute_AR_CI_optimized}
\title{Joint Anderson-Rubin CI computation}
\usage{
compute_AR_CI_optimized(
  model,
  adjust_fun,
  bs,
  sebs,
  invNs,
  g,
  type_choice,
  weights = NULL,
  method = "joint"
)
}
\arguments{
\item{model}{Fitted lm object from second-stage regression}

\item{adjust_fun}{PET_adjust or PEESE_adjust function}

\item{bs}{Effect estimates}

\item{sebs}{Standard errors}

\item{invNs}{Inverse sample sizes (instrument)}

\item{g}{Cluster variable}

\item{type_choice}{CR variance type ("CR0", "CR1", "CR2")}

\item{weights}{Optional weights for weighted AR}

\item{method}{"joint" for 2D grid, "slope_only" for subset AR (robust under weak IV)}
}
\description{
Computes AR confidence intervals using a 2D grid search over (b0, b1)
with chi^2_2 critical value. For the slope (Egger) coefficient under
weak instruments, use method = "slope_only" instead.
}
\keyword{internal}
