% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci_r2.R
\name{ci_r2}
\alias{ci_r2}
\title{Confidence interval for R^2 (exported helper)}
\usage{
ci_r2(
  r2 = NULL,
  df1 = NULL,
  df2 = NULL,
  conf_level = 0.95,
  random_predictors = TRUE,
  random_regressors = random_predictors,
  f_value = NULL,
  n = NULL,
  p = NULL,
  k = NULL,
  alpha_lower = NULL,
  alpha_upper = NULL,
  tol = 1e-09
)
}
\arguments{
\item{r2}{Numeric. The observed R^2 (may be `NULL` if `f_value` is supplied).}

\item{df1}{Integer. Numerator degrees of freedom from F.}

\item{df2}{Integer. Denominator degrees of freedom from F.}

\item{conf_level}{Numeric in (0, 1). Two-sided confidence
level for a symmetric confidence interval. Default is `0.95`.
Cannot be used with `alpha_lower` or `alpha_upper`.}

\item{random_predictors}{Logical. If `TRUE` (default), compute limits for
random predictors; if `FALSE`, compute limits for fixed predictors.}

\item{random_regressors}{Logical. Backwards-compatible alias for
`random_predictors`. If supplied, it overrides `random_predictors`.}

\item{f_value}{Numeric. The observed F statistic from the study.}

\item{n}{Integer. Sample size.}

\item{p}{Integer. Number of predictors.}

\item{k}{Integer. Alias for `p` (number of predictors).
If supplied along with `p`, they must be equal.}

\item{alpha_lower}{Numeric. Lower-tail noncoverage probability
(cannot be used with `conf_level`).}

\item{alpha_upper}{Numeric. Upper-tail noncoverage probability
(cannot be used with `conf_level`).}

\item{tol}{Numeric. Tolerance for the iterative method determining critical
values. Default is `1e-9`.}
}
\value{
A named list with the following elements:
\describe{
  \item{\code{lower_conf_limit_r2}}{The lower confidence limit for R^2.}
  \item{\code{prob_less_lower}}{Probability associated with values
less than the lower limit.}
  \item{\code{upper_conf_limit_r2}}{The upper confidence limit for R^2.}
  \item{\code{prob_greater_upper}}{Probability associated with values
greater than the upper limit.}
}
}
\description{
Compute a confidence interval for the coefficient of determination (R^2).
This implementation follows MBESS (Ken Kelley) and is exported here to avoid
importing many dependencies. It supports cases with random or fixed
predictors and can be parameterized via either degrees of freedom or
sample size (n) and number of predictors (p/k).
}
\details{
If `n` and `p` (or `k`) are provided, `df1` and `df2` are derived as
`df1 = p` and `df2 = n - p - 1`. Conversely, if `df1` and `df2` are
provided, `n = df1 + df2 + 1` and `p = df1`.
}
\references{
Kelley, K. (2007). Methods for the behavioral, educational, and social
sciences: An R package (MBESS).
}
