% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_hc_drug_by_din.R
\name{get_hc_drug_by_din}
\alias{get_hc_drug_by_din}
\title{Get a Drug Product by DIN from Health Canada Drug Product Database}
\source{
Health Canada Drug Product Database (DPD) API:
\url{https://health-products.canada.ca/api/documentation/dpd-documentation-en.html}
}
\usage{
get_hc_drug_by_din(din)
}
\arguments{
\item{din}{A character or numeric string representing the Drug Identification Number (DIN)
of the product to retrieve.}
}
\value{
A tibble with the following columns:
\itemize{
  \item \code{drug_code}: Unique code identifying the drug product
  \item \code{class_name}: Class of drug (e.g., Human, Veterinary)
  \item \code{din}: DIN assigned by Health Canada
  \item \code{brand_name}: Brand or trade name of the product
  \item \code{number_of_ais}: Number of active ingredients
  \item \code{ai_group_no}: Active ingredient group number
  \item \code{company_name}: Manufacturer name
  \item \code{last_update_date}: Date of last update in the database
}
Returns \code{NULL} if the resource is unavailable or if an error occurs.
}
\description{
Retrieves detailed information for a specific drug product listed in the
Health Canada Drug Product Database (DPD) using the RESTful API endpoint
\code{/drug/drugproduct?din=<DIN>}.

This includes details such as the Drug Identification Number (DIN),
product name, class, number of active ingredients, company name,
and update date.
}
\details{
Sends a GET request to the Health Canada Drug Product Database API.
Supports caching via the \pkg{memoise} package and enforces a
rate limit between successive API requests.

If the DIN does not exist or the API returns an error, the function
returns \code{NULL} with an informative message.

The function fails gracefully when internet resources are unavailable,
including SSL certificate errors, network timeouts, or server issues.
}
\note{
Requires an internet connection.
}
\examples{
\donttest{
  # This function requires an internet connection and downloads data from Health Canada
  result <- get_hc_drug_by_din("02456789")
  if (!is.null(result)) {
    print(result)
  }
}

}
\seealso{
\code{\link[httr]{GET}},
\code{\link[jsonlite]{fromJSON}},
\code{\link[dplyr]{as_tibble}}
}
