% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dada_phyloseq.R
\name{physeq_or_string_to_dna}
\alias{physeq_or_string_to_dna}
\title{Return a DNAStringSet object from either a character vector of DNA sequences
or the \code{refseq} slot of a phyloseq-class object}
\usage{
physeq_or_string_to_dna(physeq = NULL, dna_seq = NULL)
}
\arguments{
\item{physeq}{(required) a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{dna_seq}{You may directly use a character vector of DNA sequences
in place of physeq args. When physeq is set, dna sequences take the value
of \code{physeq@refseq}}
}
\value{
An object of class DNAStringSet (see the \code{\link[Biostrings:XStringSet-class]{Biostrings::DNAStringSet()}}
function)
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-stable-green" alt="lifecycle-stable"></a>
}}


Internally used in \code{\link[=vsearch_clustering]{vsearch_clustering()}}, \code{\link[=swarm_clustering]{swarm_clustering()}} and
\code{\link[=postcluster_pq]{postcluster_pq()}}.
}
\examples{

dna <- physeq_or_string_to_dna(data_fungi)
dna

sequences_ex <- c(
  "TACCTATGTTGCCTTGGCGGCTAAACCTACCCGGGATTTGATGGGGCGAATTAATAACGAATTCATTGAATCA",
  "TACCTATGTTGCCTTGGCGGCTAAACCTACCCGGGATTTGATGGGGCGAATTACCTGGTAAGGCCCACTT",
  "TACCTATGTTGCCTTGGCGGCTAAACCTACCCGGGATTTGATGGGGCGAATTACCTGGTAGAGGTG",
  "TACCTATGTTGCCTTGGCGGCTAAACCTACC",
  "CGGGATTTGATGGCGAATTACCTGGTATTTTAGCCCACTTACCCGGTACCATGAGGTG",
  "GCGGCTAAACCTACCCGGGATTTGATGGCGAATTACCTGG",
  "GCGGCTAAACCTACCCGGGATTTGATGGCGAATTACAAAG",
  "GCGGCTAAACCTACCCGGGATTTGATGGCGAATTACAAAG",
  "GCGGCTAAACCTACCCGGGATTTGATGGCGAATTACAAAG"
)
dna2 <- physeq_or_string_to_dna(dna_seq = sequences_ex)
dna2

}
\seealso{
\code{\link[Biostrings:XStringSet-class]{Biostrings::DNAStringSet()}}
}
\author{
Adrien Taudière
}
