% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.r
\name{get.reconstructed}
\alias{get.reconstructed}
\title{Add reconstructed tree and matrix to morpho object}
\usage{
get.reconstructed(data)
}
\arguments{
\item{data}{`morpho object` containing a fossil object}
}
\value{
a `morpho object`
}
\description{
Function to add the reconstructed tree and corresponding reconstructed
matrix to an existing morpho object
}
\examples{
# simulate tree
lambda = 0.1
mu = 0.05
tips = 10
t = TreeSim::sim.bd.taxa(n = tips, numbsim = 1, lambda = lambda, mu = mu)[[1]]

# Simulate fossils and extant taxa
rate = 0.1 # poisson sampling rate
f = FossilSim::sim.fossils.poisson(rate = rate, tree = t, root.edge = FALSE)
rho = 0.5
f2 = FossilSim::sim.extant.samples(fossils = f, tree = t, rho = rho)
morpho_data <-  sim.morpho(k = c(2,3),
                           time.tree = t,
                           trait.num = 6,
                           ancestral = TRUE,
                           br.rates = 0.1,
                           partition = c(4,2),
                           ACRV = "gamma",
                           variable = TRUE,
                           ACRV.ncats = 4,
                           fossil = f2)

re <- get.reconstructed(morpho_data)

}
