% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{filter_id_events}
\alias{filter_id_events}
\title{Filter ID/events}
\usage{
filter_id_events(data, id_events, revert = FALSE)
}
\arguments{
\item{data}{tibble. The data to be filtered.}

\item{id_events}{character (vector) or dataframe. \emph{(Vector of) ID/event(s)}
\emph{or a dataframe with \code{participant_id} and \code{session_id} columns}.}

\item{revert}{logical. Whether to revert the filter, i.e., to keep only rows
NOT matching the \code{id_events} (Default: \code{FALSE}, i.e., keep only the rows
matching the \code{id_events}).}
}
\value{
A tibble with the filtered data.
}
\description{
Given a vector of ID/events (concatenated like
\code{"{participant_id}_{session_id}"}), or a dataframe
with \code{participant_id} and \code{session_id} columns,
this function filters the data to keep or alternatively
remove the rows for the given \emph{ID/events}.
}
\examples{
\dontshow{if (requireNamespace("NBDCtoolsData", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data <- tibble::tribble(
  ~participant_id, ~session_id,
  "sub-001",       "ses-001",
  "sub-001",       "ses-002",
  "sub-002",       "ses-001",
  "sub-002",       "ses-002",
  "sub-003",       "ses-001",
  "sub-003",       "ses-002"
)

# filter using a vector of ID/events
filter_id_events(
  data,
  id_events = c("sub-001_ses-001", "sub-003_ses-002")
)

# filter using a dataframe with participant_id and session_id
data_filter <- tibble::tibble(
  participant_id = c("sub-001", "sub-003"),
  session_id = c("ses-001", "ses-002")
)
filter_id_events(
  data,
  id_events = data_filter
)

# revert filter
filter_id_events(
  data,
  id_events = c("sub-001_ses-001", "sub-003_ses-002"),
  revert = TRUE
)
\dontshow{\}) # examplesIf}
}
