% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchColRow.R
\name{searchColRow}
\alias{searchColRow}
\title{Check row identifier in a model for necessary properties.}
\usage{
searchColRow(
  file,
  file.mod = file.mod,
  dir.data,
  file.data,
  translate.input,
  formats.read,
  args.fread,
  col.id,
  tab.row
)
}
\arguments{
\item{file}{a .lst (output) or a .mod (input) control stream
file. The filename does not need to end in .lst. It is
recommended to use the output control stream because it
reflects the model as it was run rather than how it is planned
for next run. However, see file.mod and dir.data.}

\item{file.mod}{The input control stream file path. Default is to
look for \"file\" with extension changed to .mod (PSN
style). You can also supply the path to the file, or you can
provide a function that translates the output file path to the
input file path. If dir.data is missing, the input control
stream is needed. This is because the .lst does not contain
the path to the data file. The .mod file is only used for
finding the data file. How to interpret the datafile is read
from the .lst file. The default can be configured using
NMdataConf. See dir.data too.}

\item{dir.data}{The data directory can only be read from the
control stream (.mod) and not from the output file (.lst). So
if you only have the output file, use dir.data to tell in
which directory to find the data file. If dir.data is
provided, the .mod file is not used at all.}

\item{file.data}{Specification of the data file path. When this is
used, the control streams are not used at all.}

\item{translate.input}{If TRUE (default), data columns are named
as interpreted by Nonmem (in $INPUT). If data file contains
more columns than mentioned in $INPUT, these will be named as
in data file (if data file contains named variables).}

\item{args.fread}{List of arguments passed to fread. Notice that
except for "input" and "file", you need to supply all
arguments to fread if you use this argument. Default values
can be configured using NMdataConf.}

\item{col.id}{The name of the subject ID column. Optional and only
used to calculate number of subjects in data. Default is
modified by NMdataConf.}

\item{tab.row}{row-level data}
}
\value{
A character message about the findings if any
}
\description{
This function is only meant for internal use by NMscanData.
}
\keyword{internal}
