$PROBLEM    Like 001, with xgxr2, advan2

$INPUT NMROW ID TIME EVID CMT AMT DV MDV DOSE ROW

$DATA NMsimData_xgxr014_testsim1.csv
IGN=@

$SUBROUTINE ADVAN2 TRANS2

$PK
TVKA=THETA(1)
TVV=THETA(2)
TVCL=THETA(3)
                   
KA=TVKA*EXP(ETA(1))
V=TVV*EXP(ETA(2))
CL=TVCL*EXP(ETA(3))

$ERROR
  IPRED=F
  IRES=DV-IPRED

  IF (IPRED.GT.1) THEN
    W = SQRT(IPRED**2*SIGMA(1,1)**2 + SIGMA(2,2)**2)
  ELSE
    W=1
  ENDIF

  IWRES=IRES/W
  Y=F+F*ERR(1)+ERR(2)

;-----------------------INITIAL ESTIMATES---------------------------------
$THETA (0,0.127192)  ; POPKA
$THETA (0,0.042708)  ; POPCL
$THETA (0,0.625626)  ; POPV2


$OMEGA 0.0782213 
$OMEGA 0.0236941 
$OMEGA 0.0440672 


$SIGMA 0.199732    
$SIGMA 0.000403546 




$SIMULATION ONLYSIM (1027128956) SUBPROBLEMS=3 

$TABLE NMROW ROW TVKA TVV TVCL KA V CL PRED IPRED NOPRINT FILE=xgxr014_testsim1.tab

