% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPHMC.R
\name{NPHMC}
\alias{NPHMC}
\title{Title}
\usage{
NPHMC(
  n = NULL,
  power = 0.8,
  alpha = 0.05,
  accrualtime = NULL,
  followuptime = NULL,
  p = 0.5,
  accrualdist = c("uniform", "increasing", "decreasing"),
  hazardratio = NULL,
  oddsratio = NULL,
  pi0 = NULL,
  survdist = c("exp", "weib"),
  k = 1,
  lambda0 = NULL,
  data = NULL
)
}
\arguments{
\item{n}{sample size needed for power calculation}

\item{power}{powered needed for sample size calculation}

\item{alpha}{level of significance of statistical test (default is 0.05)}

\item{accrualtime}{level of accrual period}

\item{followuptime}{length of follow up time}

\item{p}{proportion of subjects in treatment arm (default is 0.5)}

\item{accrualdist}{accrual pattern (uniform, decreasing, increasing)}

\item{hazardratio}{hazard ratio of uncured patients between two arms (must be greater than 0)}

\item{oddsratio}{odds ratio of cured patients between two arms.
It must be greater than 0. If it is 0, the model is reduced to standard proportional hazards model.}

\item{pi0}{cure rate for the control arm (between 0 and 1)}

\item{survdist}{distribution of uncured patients (\code{exp} or \code{weib})}

\item{k}{shape parameter if survdist = 'weib' (By default, it is 1 referrring to exponential distribution)}

\item{lambda0}{scale parameter of exponential or Weibull distribution for survival times of uncured patients in the control arm.}

\item{data}{observed or historical data if available}
}
\value{
a NPHMC object
}
\description{
Title
}
\examples{
NPHMC(power=0.90,alpha=0.05,accrualtime=3,followuptime=4,p=0.5,accrualdist="uniform",
hazardratio=2/2.5,oddsratio=2.25,pi0=0.1,survdist="exp",k=1,lambda0=0.5)
data(e1684szdata)
NPHMC(power=0.80,alpha=0.05,accrualtime=4,followuptime=3,p=0.5,accrualdist="uniform",
     data=e1684szdata)
n=seq(100, 500, by=50)
NPHMC(n=n, alpha=0.05,accrualtime=3,followuptime=4,p=0.5,
     accrualdist="uniform", hazardratio=2/2.5,oddsratio=2.25,pi0=0.1,survdist="exp",
     k=1,lambda0=0.5)
n=seq(100, 500, by=50)
NPHMC(n=n,alpha=0.05,accrualtime=4,followuptime=3,p=0.5,
     accrualdist="uniform",data=e1684szdata)
}
