% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identifyHubs.R
\name{identifyHubs}
\alias{identifyHubs}
\title{identifyHubs}
\usage{
identifyHubs(X, delta, tau, ebic.gamma = 0.1)
}
\arguments{
\item{X}{A data matrix of dimension n x p representing samples (rows) by
features (columns).}

\item{delta}{A numeric value indicating the proportion of nodes to
considered as hubs in a network.}

\item{tau}{A user-specified cutoff for the number of hubs.}

\item{ebic.gamma}{A numeric value specifying the tuning parameter for the
extended Bayesian information criterion (eBIC)
used in network estimation.}
}
\value{
A list containing (1) the selected sparse graph structure and
model selection results; (2) a data frame of feature names with
their associated network characteristics (e.g., degree centrality);
and (3) a character vector of top-ranked hub features
(e.g., hub genes or proteins).
}
\description{
A function to identify hub nodes (i.e., genes or proteins)
from high-dimensional data using network-based criteria.
}
\examples{
library(plsgenomics)
data(Colon) ## Data from plsgenomics R package
X = data.frame(Colon$X[,1:100]) ## The first 100 genes
Z = data.frame(Colon$X[,101:102]) ## Two clinical covariates
colnames(Z) = c("Z1", "Z2")
Y = as.vector(Colon$X[,1000])  ## Continuous outcome variable

## Apply identifyHubs():
preNG = identifyHubs(X=X, delta=0.05, tau=5, ebic.gamma = 0.1)

## Explore preNG results:
## To display the degree centrality for each node,
## sorted from strongest to weakest.
preNG$assoResults
preNG$hubs ## Returns the names of the identified hub nodes.

}
