% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{brainvolume_df}
\alias{brainvolume_df}
\title{Meta-Analysis on Human Brain Volume and Intelligence}
\format{
A data frame with 83 observations and 8 variables:
\describe{
  \item{study_name}{Study identifier (character)}
  \item{year}{Year of publication (integer)}
  \item{r}{Correlation coefficient between brain volume and intelligence (numeric)}
  \item{z}{Fisher’s z-transformed correlation (numeric)}
  \item{z_se}{Standard error of the Fisher’s z value (numeric)}
  \item{n}{Sample size (integer)}
  \item{sex}{Sex composition of the sample (factor with 4 levels)}
  \item{mean_age}{Mean age of participants (numeric)}
}
}
\source{
Data taken from the metaviz package version 0.3.1
}
\usage{
data(brainvolume_df)
}
\description{
This dataset, brainvolume_df, is a data frame containing 83 empirical studies included in the
meta-analysis by Pietschnig, Penke, Wicherts, Zeiler, and Voracek (2015), which examined the
association between human brain volume and intelligence as measured by full-scale IQ. The dataset
includes study identifiers, publication year, correlation coefficients, Fisher’s z-transformed values,
standard errors, sample sizes, sex composition, and mean participant age. These data provide a
comprehensive resource for investigating population-level relationships between brain volume and
cognitive ability.
}
\details{
The dataset name has been kept as brainvolume_df to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
NeuroDataSets package and assists users in identifying its specific characteristics.
The suffix df indicates that the dataset is a data frame. The original content has not been modified
in any way.
}
