% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Octopus900.r
\name{octo900.presentStatic}
\alias{octo900.presentStatic}
\title{Present static on O900 (internal use)}
\arguments{
\item{stim}{Stimulus to present (a list, see details).}

\item{nextStim}{The stimulus to present after stim
(it is not presented, but projector can move to it during response window)}

\item{F310}{If \code{F310} is \code{FALSE}, response is taken from internal button.
If \code{F310} is \code{TRUE} , response is taken from external controller}
}
\value{
A list containing
\itemize{
\item \code{err}  String message or NULL for no error.
\item \code{seen} 1 if seen, 0 otherwise. (See details for F310)
\item \code{time} Reaction time (if seen).
}
}
\description{
Implementation of opiPresent for the Octopus090 machine.
Version for opiStaticStimulus.

This is for internal use only. Use \code{\link[=opiPresent]{opiPresent()}} with
\code{stim} as class \code{opiStaticStimulus} and you will get the Value back.
}
\details{
\code{stim} is a list containing at least the following 3 elements:
\itemize{
\item \code{x}, x-coordinate in degrees (floating point) (range $[-30,30]$).
\item \code{y}, y-coordinate in degrees (floating point) (range $[-30,30]$).
\item \code{level} is luminance in cd/\eqn{\mbox{m}^2}{m^2}, and is rounded to the nearest
whole dB for display (range 0 to 50). 0dB is 10000aps.
}

It can also contain:
\itemize{
\item \code{responseWindow} from start of stimulus presentation in milliseconds (default is 1500).
\item \code{duration} of stimulus on in milliseconds (default 200).
\item \code{color} one of \code{.opi_env$O900$STIM_WHITE}, \code{.opi_env$O900$STIM_BLUE} or
\code{.opi_env$O900$STIM_RED}.  It must be same as that initialised
by \code{\link[=opiSetup]{opiSetup()}} or \code{\link[=opiInitialize]{opiInitialize()}}
(default \code{.opi_env$O900$STIM_WHITE}).
\item \code{size} of stimulus diameter in degrees (default Size III == 0.43).
This is rounded to the nearest support Goldmann size.
}

If responses are taken from the F310 Controller then
\itemize{
\item If the L button is pressed, \code{seen} is set to 1.
\item If the R button is pressed, \code{seen} is set to 2.
\item If no button is pressed within \code{responseWindow}, then \code{seen} is set to 0.
}

If stim is null, always return err = NULL status.
}
