test_that("dnorm_mixture returns non-negative values", {
  x <- seq(-5, 5, length.out = 50)
  mu <- c(-2, 2)
  sigma <- c(1, 1.5)
  pi <- c(0.3, 0.7)

  dens <- dnorm_mixture(x, mu, sigma, pi)

  expect_true(all(dens >= 0))
})

test_that("dnorm_mixture matches dnorm for a single component", {
  x <- seq(-2, 2, length.out = 10)
  mu <- 0
  sigma <- 1
  pi <- 1

  dens_mix <- dnorm_mixture(x, mu, sigma, pi)
  dens_ref <- dnorm(x, mean = mu, sd = sigma)

  expect_equal(dens_mix, dens_ref, tolerance = 1e-12)
})


