% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionReport.R
\name{createPredictionReport}
\alias{createPredictionReport}
\title{createPredictionReport}
\usage{
createPredictionReport(
  connectionHandler,
  schema,
  plpTablePrefix,
  databaseTablePrefix = plpTablePrefix,
  cgTablePrefix = plpTablePrefix,
  modelDesignId,
  output,
  intermediatesDir = file.path(tempdir(), "plp-prot"),
  outputFormat = "html_document"
)
}
\arguments{
\item{connectionHandler}{The connection handler to the results database}

\item{schema}{The result database schema}

\item{plpTablePrefix}{The prediction table prefix}

\item{databaseTablePrefix}{The database table name e.g., database_meta_data}

\item{cgTablePrefix}{The cohort generator table prefix}

\item{modelDesignId}{The model design ID of interest}

\item{output}{The folder name where main.html will be save to}

\item{intermediatesDir}{The work directory for rmarkdown}

\item{outputFormat}{the type of outcome html_document or html_fragment}
}
\value{
An named R list with the elements 'standard' and 'source'
}
\description{
Generates a report for a given prediction model design
}
\details{
Specify the connection handler to the result database, the schema name
and the modelDesignId of interest to generate a html report summarizing the
performance of models developed across databases.
}
\seealso{
Other Reporting: 
\code{\link{generateFullReport}()},
\code{\link{generatePresentation}()},
\code{\link{generatePresentationMultiple}()},
\code{\link{generateSummaryPredictionReport}()}
}
\concept{Reporting}
